<?php

namespace App\Http\Controllers\Dashboard\Settings\MerchantSpecialityType;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

//Add Models
use App\Models\SpecialityType;

class UpdateController extends Controller
{
    public function index(Request $request)
    {	
    	$params = $request->all();
        $record = SpecialityType::find($params['type_id']);

        if ($record->update($params)) {
            $params = [
                'user_id' => auth()->user()->id, 
                'activity' => 'Speciality Type Update',
                'reference_id' => $record->id,
                'table' => 'speciality_types',
                'remarks' => 'Success updating speciality type.',
            ];
            
            $this->addLogs($params);

    		return response()->json(['message' => 'success'],200);	
    	}

        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Speciality Type Update',
            'reference_id' => $record->id,
            'table' => 'speciality_types',
            'remarks' => 'Failed updating speciality type.',
        ];
        
        $this->addLogs($params);

        return response()->json(['message' => $record->getErrors()]);
    }

    public function status($id)
    {
        $specialityType = SpecialityType::find(base64_decode($id));

        if ($specialityType->status == 1) {
        	
        	$specialityType->update(['status' => 0]);

            $params = [
                'user_id' => auth()->user()->id, 
                'activity' => 'Speciality Type Deactivation',
                'reference_id' => base64_decode($id),
                'table' => 'speciality_types',
                'remarks' => 'Speciality Type deactivated successfully',
            ];
            
            $this->addLogs($params);

        	return response()->json(['message' => 'Speciality Type deactivated successfully']);
        }

       	$specialityType->update(['status' => 1]);

        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Speciality Type Activation',
            'reference_id' => base64_decode($id),
            'table' => 'speciality_types',
            'remarks' => 'Speciality Type activated successfully',
        ];
        
        $this->addLogs($params);

        return response()->json(['message' => 'Speciality Type activated successfully']);
    }
}
