<?php

namespace App\Http\Controllers\Dashboard\Settings\MerchantSpecialityType;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

//Add Models
use App\Models\SpecialityType;

class CreateController extends Controller
{
    public function index(Request $request)
    {
    	$params = $request->all();
    	unset($params['type_id']);
        $record = new SpecialityType($params);

    	if (!$record->save()) {
            $params = [
                'user_id' => auth()->user()->id, 
                'activity' => 'Speciality Type Register',
                'reference_id' => null,
                'table' => 'speciality_types',
                'remarks' => 'Failed registering speciality type.',
            ];
            
            $this->addLogs($params);

    		return response()->json(['message' => $record->getErrors()]);
    	}

        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Speciality Type Register',
            'reference_id' => $record->id,
            'table' => 'speciality_types',
            'remarks' => 'Success registering speciality type.',
        ];

        $this->addLogs($params);

    	return response()->json(['message' => 'success'],200);	
    }
}
