<?php

namespace App\Http\Controllers\Dashboard\Settings\MerchantSpeciality;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

//Add External Classes
use Yajra\Datatables\Datatables;

//Add Models
use App\Models\SpecialityType;
use App\Models\Speciality;

class ViewController extends Controller
{
    public function index()
    {   
        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Specialities View',
            'reference_id' => null,
            'table' => 'specialities',
            'remarks' => 'Success viewing all specialities.',
        ];

        $this->addLogs($params);

    	return view('dashboard.settings.merchant-specialities.index',[
            'speciality_types' => $this->getActiveSpecialityTypes()
        ]);
    }

    public function specialityList()
    {
    	$specialities = Speciality::select([
                            'specialities.*',
                            'speciality_types.name as speciality_type_name'
                        ])
                        ->leftJoin('speciality_types','speciality_types.id','specialities.speciality_type_id')
                        ->latest()
                        ->get();

        return Datatables::of($specialities)
            ->addIndexColumn()
            ->addColumn('name', function($speciality){
                $name = ucwords($speciality->name);
                $photo = (isset($speciality->image->path)) ? 
                            '<img src="'.config('app.AWS_BUCKET_URL').$speciality->image->path.'" class="rounded-circle mr-2" width="40px" height="40px">' : 
                            '<img src='.asset('admin_dashboard/img/default.png').' class="rounded-circle mr-2" width="40px" height="40px">' ;

                return $photo.' '.$name;
            })
            ->addColumn('description', function($speciality){
                return ucwords($speciality->description);
            })
            ->addColumn('speciality_type', function($speciality){
                return ucwords($speciality->speciality_type_name);
            })
            ->addColumn('status', function($speciality){
                $status = $speciality->status == 1 ? 
                    '<i class="mdi mdi-checkbox-blank-circle text-success"></i> Active' :
                    '<i class="mdi mdi-checkbox-blank-circle text-danger"></i> Inactive' ;
                return $status;
            })
            ->addColumn('created_at', function($speciality){
                return $speciality->created_at->format('M d,Y h:i:s A');
            })
            ->addColumn('action', function ($speciality){
                $status = $speciality->status == 1 ? 'Deactivate' : 'Activate';
                $button = '<a href='.route('settings.merchant.specialities.edit',base64_encode($speciality->id)).' id="edit">
                                <button class="btn btn-sm btn-primary mr-1"> 
                                    <i class="mdi mdi-table-edit"></i> Edit
                                </button>
                            </a>';
                $button .= $speciality->status == 1 ?
                    '<a href='.route('settings.merchant.specialities.status',base64_encode($speciality->id)).' id="status" data-status='.$status.'>
                        <button class="btn btn-sm btn-danger"> 
                            <i class="mdi mdi-minus-circle"></i> Deactivate
                        </button>
                    </a>':
                    '<a href='.route('settings.merchant.specialities.status',base64_encode($speciality->id)).' id="status" data-status='.$status.'>
                        <button class="btn btn-sm btn-success pl-3 pr-3"> 
                            <i class="mdi mdi-check-circle"></i> Activate
                        </button>
                    </a>';

                $action = '<div style="display:flex">
                                '.$button.'
                           </div>';
                return $action;
            })
        	->escapeColumns([])->make(true);
    }

    public function edit($id)
    {
        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Speciality View',
            'reference_id' => base64_decode($id),
            'table' => 'specialities',
            'remarks' => 'Success viewing edit speciality.',
        ];
        
        $this->addLogs($params);

        $specialities = Speciality::find(base64_decode($id));
        $specialities['types'] = $this->getActiveSpecialityTypes();
        
        return $specialities;
    }

    public function getActiveSpecialityTypes()
    {
        return SpecialityType::whereStatus(1)->get(['id','name']);
    }
}
