<?php

namespace App\Http\Controllers\Dashboard\Settings\MerchantSpeciality;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

//Add Models
use App\Models\Speciality;

class UpdateController extends Controller
{
    public function index(Request $request)
    {	
    	$params = $request->all();
        $record = Speciality::find($params['speciality_id']);

        if ($record->update($params)) {
            $params = [
                'user_id' => auth()->user()->id, 
                'activity' => 'Speciality Update',
                'reference_id' => $record->id,
                'table' => 'specialities',
                'remarks' => 'Success updating speciality.',
            ];

            $this->addLogs($params);

            //SAVE IMAGE TO S3
            $this->storeSpecialityImage($request, $record->id);

    		return response()->json(['message' => 'success'],200);	
    	}

        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Speciality Update',
            'reference_id' => null,
            'table' => 'specialities',
            'remarks' => 'Error updating speciality.',
        ];

        $this->addLogs($params);

    	return response()->json(['message' => $record->getErrors()]);
    }

    public function status($id)
    {
        $speciality = Speciality::find(base64_decode($id));

        if ($speciality->status == 1) {
        	
        	$speciality->update(['status' => 0]);

            $params = [
                'user_id' => auth()->user()->id, 
                'activity' => 'Speciality Deactivation',
                'reference_id' => base64_decode($id),
                'table' => 'specialities',
                'remarks' => 'Success deactivating speciality.',
            ];
            
            $this->addLogs($params);

        	return response()->json(['message' => 'Speciality deactivated successfully']);
        }

       	$speciality->update(['status' => 1]);

        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Speciality Activation',
            'reference_id' => base64_decode($id),
            'table' => 'specialities',
            'remarks' => 'Success activating speciality.',
        ];

        $this->addLogs($params);

        return response()->json(['message' => 'Speciality activated successfully']);
    }
}
