<?php

namespace App\Http\Controllers\Dashboard\Settings\MerchantSpeciality;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

//Add Models
use App\Models\Speciality;

class CreateController extends Controller
{
    public function index(Request $request)
    {
    	$params = $request->all();
    	unset($params['speciality_id']);
        $record = new Speciality($params);

    	if (!$record->save()) {
            $params = [
                'user_id' => auth()->user()->id, 
                'activity' => 'Speciality Registration',
                'reference_id' => null,
                'table' => 'specialities',
                'remarks' => 'Error registering speciality.',
            ];

            $this->addLogs($params);

    		return response()->json(['message' => $record->getErrors()]);
    	}

        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Speciality Registration',
            'reference_id' => $record->id,
            'table' => 'specialities',
            'remarks' => 'Success registering speciality.',
        ];

        $this->addLogs($params);

        //SAVE IMAGE TO S3
        $this->storeSpecialityImage($request, $record->id);     
           
    	return response()->json(['message' => 'success'],200);	
    }
}
