<?php

namespace App\Http\Controllers\Dashboard\Settings\MerchantProductCategory;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

//Add External Classes
use Yajra\Datatables\Datatables;

//Add Models
use App\Models\ProductCategory;

class ViewController extends Controller
{
    public function index()
    {   
        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Product Categories View',
            'reference_id' => null,
            'table' => 'categories',
            'remarks' => 'Product Categories View Success',
        ];

        $this->addLogs($params);

    	return view('dashboard.settings.merchant-categories.index');
    }

    public function merchantCategoryList()
    {
    	$categories = ProductCategory::where('merchant_id', auth()->user()->account->merchant_id)->latest()->get();

        return Datatables::of($categories)
            ->addIndexColumn()
            ->addColumn('name', function($category){
                return ucwords($category->name);
            })
            ->addColumn('description', function($category){
                return ucwords($category->description);
            })
            ->addColumn('status', function($category){
               	$status = $category->status == 1 ? 
                    '<i class="mdi mdi-checkbox-blank-circle text-success"></i> Active' :
                    '<i class="mdi mdi-checkbox-blank-circle text-danger"></i> Inactive' ;
                return $status;
            })
            ->addColumn('created_at', function($category){
                return $category->created_at->format('M d,Y h:i:s A');
            })
            ->addColumn('action', function ($category){
                $status = $category->status == 1 ? 'Deactivate' : 'Activate';
                $button = '<a href='.route('merchants.categories.edit',base64_encode($category->id)).' id="edit">
                                <button class="btn btn-sm btn-primary mr-1"> 
                                    <i class="mdi mdi-table-edit"></i> Edit
                                </button>
                            </a>';
                $button .= $category->status == 1 ?
                    '<a href='.route('merchants.categories.status',base64_encode($category->id)).' id="status" data-status='.$status.'>
                        <button class="btn btn-sm btn-danger"> 
                            <i class="mdi mdi-minus-circle"></i> Deactivate
                        </button>
                    </a>':
                    '<a href='.route('merchants.categories.status',base64_encode($category->id)).' id="status" data-status='.$status.'>
                        <button class="btn btn-sm btn-success pl-3 pr-3"> 
                            <i class="mdi mdi-check-circle"></i> Activate
                        </button>
                    </a>';

            	$action = '<div style="display:flex">
                                '.$button.'
            			   </div>';
            	return $action;
            })
        	->escapeColumns([])->make(true);
    }

    public function edit($id)
    {
        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Merchant Product Category View',
            'reference_id' => base64_decode($id),
            'table' => 'categories',
            'remarks' => 'Success viewing edit merchant product category.',
        ];
        
        $this->addLogs($params);

        return ProductCategory::find(base64_decode($id));
    }
}
