<?php

namespace App\Http\Controllers\Dashboard\Settings\MerchantProductCategory;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

//Add Models
use App\Models\ProductCategory;

class UpdateController extends Controller
{
    public function index(Request $request)
    {	
    	$params = $request->all();
        $record = ProductCategory::find($params['category_id']);

        if ($record->update($params)) {
            $params = [
                'user_id' => auth()->user()->id, 
                'activity' => 'Merchant Product Category Update',
                'reference_id' => $record->id,
                'table' => 'categories',
                'remarks' => 'Success updating merchant product category.',
            ];

            $this->addLogs($params);

    		return response()->json(['message' => 'success'],200);	
    	}

        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Merchant Product Category Update',
            'reference_id' => null,
            'table' => 'categories',
            'remarks' => 'Error updating merchant product category.',
        ];

        $this->addLogs($params);

    	return response()->json(['message' => $record->getErrors()]);
    }

    public function status($id)
    {
        $areaCode = ProductCategory::find(base64_decode($id));

        if ($areaCode->status == 1) {
        	
        	$areaCode->update(['status' => 0]);

            $params = [
                'user_id' => auth()->user()->id, 
                'activity' => 'Merchant Product Category Deactivation',
                'reference_id' => base64_decode($id),
                'table' => 'categories',
                'remarks' => 'Success deactivating merchant product category.',
            ];
            
            $this->addLogs($params);

        	return response()->json(['message' => 'Merchant Product Category deactivated successfully']);
        }

       	$areaCode->update(['status' => 1]);

        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Merchant Product Category Activation',
            'reference_id' => base64_decode($id),
            'table' => 'categories',
            'remarks' => 'Success activating merchant product category.',
        ];

        $this->addLogs($params);

        return response()->json(['message' => 'Merchant Product Category activated successfully']);
    }
}
