<?php

namespace App\Http\Controllers\Dashboard\Settings\MerchantProductCategory;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

//Add Models
use App\Models\ProductCategory;

class CreateController extends Controller
{
    public function index(Request $request)
    {
    	$params = $request->all();
        unset($params['category_id']);
        $params['merchant_id'] = auth()->user()->account->merchant_id;
        $record = new ProductCategory($params);

    	if (!$record->save()) {
            $params = [
                'user_id' => auth()->user()->id, 
                'activity' => 'Merchant Product Categories Registration',
                'reference_id' => null,
                'table' => 'categories',
                'remarks' => 'Error registering merchant product category.',
            ];

            $this->addLogs($params);

    		return response()->json(['message' => $record->getErrors()]);
    	}

        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Merchant Product Categories Registration',
            'reference_id' => $record->id,
            'table' => 'categories',
            'remarks' => 'Success registering merchant product category.',
        ];

        $this->addLogs($params);
        
    	return response()->json(['message' => 'success'],200);	
    }
}
