<?php

namespace App\Http\Controllers\Dashboard\Settings\MerchantEstablishmentSchedule;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

//Add Models
use App\Models\EstablishmentSchedule;

use Redirect;

class CreateController extends Controller
{
    public function index(Request $request, $id)
    {
    	$params = [
    		'establishment_id'	=> base64_decode($id),
    		'monday'			=> $this->formatRequestTime($request->monday),
    		'tuesday' 			=> $this->formatRequestTime($request->tuesday),
    		'wednesday'			=> $this->formatRequestTime($request->wednesday),
    		'thursday'			=> $this->formatRequestTime($request->thursday),
    		'friday'			=> $this->formatRequestTime($request->friday),
    		'saturday'			=> $this->formatRequestTime($request->saturday),
    		'sunday'			=> $this->formatRequestTime($request->sunday),
    	];

    	EstablishmentSchedule::create($params);

        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Establishment Schedule Registration',
            'reference_id' => base64_decode($id),
            'table' => 'establishment_schedules',
            'remarks' => 'Success registering establishment schedule.',
        ];

        $this->addLogs($params);

        return Redirect::route('merchants.schedules')
                    ->with(['success' => 'Successfully added schedule']);

    }

    public function formatRequestTime($times)
    {
    	$am = [];
        $pm = [];
        foreach ($times as $key => $time) {
            if ($key == 0 || $key == 1) {
               $am[] = ($time != null) ? $this->twelveHourFormat($time) : '00:00 AM';
            } else {
               $pm[] = ($time != null) ? $this->twelveHourFormat($time) : '00:00 PM';
            }
        }

        $implodeTime = '['.implode(" - ", $am).'] - ['.implode(" - ", $pm).']';
        $timeformat = '[00:00 AM - 00:00 AM] - [00:00 PM - 00:00 PM]';

        return $implodeTime == $timeformat ? null : $implodeTime;
    }

    // 12-hour clock format
    public function twelveHourFormat($time)
    {
        return date('h:i A', strtotime($time));
    }
}
