<?php

namespace App\Http\Controllers\Dashboard\Settings\MerchantAreaCode;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

//Add Models
use App\Models\MerchantAreaCode;

class UpdateController extends Controller
{
    public function index(Request $request)
    {	
    	$params = $request->all();
        $record = MerchantAreaCode::find($params['area_id']);

        if ($record->update($params)) {
            $params = [
                'user_id' => auth()->user()->id, 
                'activity' => 'Merchant Area Code Update',
                'reference_id' => $record->id,
                'table' => 'area_codes',
                'remarks' => 'Success updating merchant area code.',
            ];

            $this->addLogs($params);

    		return response()->json(['message' => 'success'],200);	
    	}

        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Merchant Area Code Update',
            'reference_id' => null,
            'table' => 'area_codes',
            'remarks' => 'Error updating merchant area code.',
        ];

        $this->addLogs($params);

    	return response()->json(['message' => $record->getErrors()]);
    }

    public function status($id)
    {
        $areaCode = MerchantAreaCode::find(base64_decode($id));

        if ($areaCode->status == 1) {
        	
        	$areaCode->update(['status' => 0]);

            $params = [
                'user_id' => auth()->user()->id, 
                'activity' => 'Merchant Area Code Deactivation',
                'reference_id' => base64_decode($id),
                'table' => 'area_codes',
                'remarks' => 'Success deactivating merchant area code.',
            ];
            
            $this->addLogs($params);

        	return response()->json(['message' => 'Merchant Area Code deactivated successfully']);
        }

       	$areaCode->update(['status' => 1]);

        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Merchant Area Code Activation',
            'reference_id' => base64_decode($id),
            'table' => 'area_codes',
            'remarks' => 'Success activating merchant area code.',
        ];

        $this->addLogs($params);

        return response()->json(['message' => 'Merchant Area Code activated successfully']);
    }
}
