<?php

namespace App\Http\Controllers\Dashboard\Settings\MerchantAreaCode;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

//Add Models
use App\Models\MerchantAreaCode;

class CreateController extends Controller
{
    public function index(Request $request)
    {
    	$params = $request->all();
    	unset($params['area_id']);
        $record = new MerchantAreaCode($params);

    	if (!$record->save()) {
            $params = [
                'user_id' => auth()->user()->id, 
                'activity' => 'Merchant Area Code Registration',
                'reference_id' => null,
                'table' => 'area_codes',
                'remarks' => 'Error registering merchant area code.',
            ];

            $this->addLogs($params);

    		return response()->json(['message' => $record->getErrors()]);
    	}

        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Merchant Area Code Registration',
            'reference_id' => $record->id,
            'table' => 'area_codes',
            'remarks' => 'Success registering merchant area code.',
        ];

        $this->addLogs($params);
        
    	return response()->json(['message' => 'success'],200);	
    }
}
