<?php

namespace App\Http\Controllers\Dashboard\Settings\MemberType;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

//Add External Classes
use Yajra\Datatables\Datatables;

//Add Models
use App\Models\MemberType;

class ViewController extends Controller
{
    public function index()
    {
        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Member Type View',
            'reference_id' => null,
            'table' => 'member_types',
            'remarks' => 'Member Type View Success',
        ];

        $this->addLogs($params);

        return view('dashboard.settings.member-types.index');
    }

    public function memberTypeList()
    {
    	$memberTypes = MemberType::latest()->get();

        return Datatables::of($memberTypes)
            ->addIndexColumn()
            ->addColumn('name', function($type){
                return ucwords($type->name);
            })
            ->addColumn('status', function($type){
               	$status = $type->status == 1 ? 
                    '<i class="mdi mdi-checkbox-blank-circle text-success"></i> Active' :
                    '<i class="mdi mdi-checkbox-blank-circle text-danger"></i> Inactive' ;
                return $status;
            })
            ->addColumn('created_at', function($type){
                return $type->created_at->format('M d,Y h:i:s A');
            })
            ->addColumn('action', function ($type){
                $status = $type->status == 1 ? 'Deactivate' : 'Activate';
                $button = '<a href='.route('settings.member.types.edit',base64_encode($type->id)).' id="edit">
                                <button class="btn btn-sm btn-primary mr-1"> 
                                    <i class="mdi mdi-table-edit"></i> Edit
                                </button>
                            </a>';
                $button .= $type->status == 1 ?
                    '<a href='.route('settings.member.types.status',base64_encode($type->id)).' id="status" data-status='.$status.'>
                        <button class="btn btn-sm btn-danger"> 
                            <i class="mdi mdi-minus-circle"></i> Deactivate
                        </button>
                    </a>':
                    '<a href='.route('settings.member.types.status',base64_encode($type->id)).' id="status" data-status='.$status.'>
                        <button class="btn btn-sm btn-success pl-3 pr-3"> 
                            <i class="mdi mdi-check-circle"></i> Activate
                        </button>
                    </a>';

            	$action = '<div style="display:flex">
                                '.$button.'
            			   </div>';
            	return $action;
            })
        	->escapeColumns([])->make(true);
    }

    public function edit($id)
    {
        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Member Type Edit View',
            'reference_id' => base64_decode($id),
            'table' => 'member_types',
            'remarks' => 'Member Type Edit View Success',
        ];
        
        $this->addLogs($params);

        return MemberType::find(base64_decode($id));
    }
}
