<?php

namespace App\Http\Controllers\Dashboard\Settings\MemberType;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

//Add Models
use App\Models\MemberType;

class UpdateController extends Controller
{
    public function index(Request $request)
    {	
    	$params = $request->all();
        $record = MemberType::find($params['member_id']);

        if ($record->update($params)) {
            $params = [
                'user_id' => auth()->user()->id, 
                'activity' => 'Member Type Update',
                'reference_id' => $record->id,
                'table' => 'member_types',
                'remarks' => 'Success updating member type.',
            ];
            
            $this->addLogs($params);

    		return response()->json(['message' => 'success'],200);	
    	}

        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Member Type Update',
            'reference_id' => $record->id,
            'table' => 'member_types',
            'remarks' => 'Failed updating member type.',
        ];
        
        $this->addLogs($params);

        return response()->json(['message' => $record->getErrors()]);
    }

    public function status($id)
    {
        $memberType = MemberType::find(base64_decode($id));

        if ($memberType->status == 1) {
        	
        	$memberType->update(['status' => 0]);

            $params = [
                'user_id' => auth()->user()->id, 
                'activity' => 'Member Type Deactivation',
                'reference_id' => base64_decode($id),
                'table' => 'member_types',
                'remarks' => 'Member Type deactivated successfully',
            ];
            
            $this->addLogs($params);

        	return response()->json(['message' => 'Member Type deactivated successfully']);
        }

       	$memberType->update(['status' => 1]);

        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Member Type Activation',
            'reference_id' => base64_decode($id),
            'table' => 'member_types',
            'remarks' => 'Member Type activated successfully',
        ];
        
        $this->addLogs($params);

        return response()->json(['message' => 'Member Type activated successfully']);
    }
}
