<?php

namespace App\Http\Controllers\Dashboard\Settings\MemberType;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

//Add Models
use App\Models\MemberType;

class CreateController extends Controller
{
    public function index(Request $request)
    {
    	$params = $request->all();
    	unset($params['member_id']);
        $record = new MemberType($params);

    	if (!$record->save()) {
            $params = [
                'user_id' => auth()->user()->id, 
                'activity' => 'Member Type Register',
                'reference_id' => null,
                'table' => 'member_types',
                'remarks' => 'Failed registering member type.',
            ];
            
            $this->addLogs($params);

    		return response()->json(['message' => $record->getErrors()]);
    	}

        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Member Type Register',
            'reference_id' => $record->id,
            'table' => 'member_types',
            'remarks' => 'Success registering member type.',
        ];

        $this->addLogs($params);

    	return response()->json(['message' => 'success'],200);	
    }
}
