<?php

namespace App\Http\Controllers\Dashboard\Settings\MemberAreaCode;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

//Add External Classes
use Yajra\Datatables\Datatables;

//Add Models
use App\Models\AreaCode;

class ViewController extends Controller
{
    public function index()
    {
        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Area Code View',
            'reference_id' => null,
            'table' => 'area_codes',
            'remarks' => 'Success viewing all area codes.',
        ];

        $this->addLogs($params);

    	return view('dashboard.settings.member-areacodes.index');
    }

    public function areaCodeList()
    {
    	$areaCodes = AreaCode::latest()->get();

        return Datatables::of($areaCodes)
            ->addIndexColumn()
            ->addColumn('area_name', function($area_code){
                return ucwords($area_code->area_name);
            })
           	->addColumn('area_code', function($area_code){
                return $area_code->area_code;
            })
            ->addColumn('status', function($area_code){
               	$status = $area_code->status == 1 ? 
                    '<i class="mdi mdi-checkbox-blank-circle text-success"></i> Active' :
                    '<i class="mdi mdi-checkbox-blank-circle text-danger"></i> Inactive' ;
                return $status;
            })
            ->addColumn('created_at', function($area_code){
                return $area_code->created_at->format('M d,Y h:i:s A');
            })
            ->addColumn('action', function ($area_code){
                $status = $area_code->status == 1 ? 'Deactivate' : 'Activate';
                $button = '<a href='.route('settings.member.areacodes.edit',base64_encode($area_code->id)).' id="edit">
                                <button class="btn btn-sm btn-primary mr-1"> 
                                    <i class="mdi mdi-table-edit"></i> Edit
                                </button>
                            </a>';
                $button .= $area_code->status == 1 ?
                    '<a href='.route('settings.member.areacodes.status',base64_encode($area_code->id)).' id="status" data-status='.$status.'>
                        <button class="btn btn-sm btn-danger"> 
                            <i class="mdi mdi-minus-circle"></i> Deactivate
                        </button>
                    </a>':
                    '<a href='.route('settings.member.areacodes.status',base64_encode($area_code->id)).' id="status" data-status='.$status.'>
                        <button class="btn btn-sm btn-success pl-3 pr-3"> 
                            <i class="mdi mdi-check-circle"></i> Activate
                        </button>
                    </a>';

            	$action = '<div style="display:flex">
                                '.$button.'
            			   </div>';
            	return $action;
            })
        	->escapeColumns([])->make(true);
    }

    public function edit($id)
    {
        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Area Code View',
            'reference_id' => base64_decode($id),
            'table' => 'area_codes',
            'remarks' => 'Success viewing edit area codes.',
        ];
        
        $this->addLogs($params);

        return AreaCode::find(base64_decode($id));
    }
}
