<?php

namespace App\Http\Controllers\Dashboard\Settings\MemberAreaCode;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

//Add Models
use App\Models\AreaCode;

class UpdateController extends Controller
{
    public function index(Request $request)
    {	
    	$params = $request->all();
        $record = AreaCode::find($params['area_id']);

        if ($record->update($params)) {
            $params = [
                'user_id' => auth()->user()->id, 
                'activity' => 'Area Code Update',
                'reference_id' => $record->id,
                'table' => 'area_codes',
                'remarks' => 'Success updating area code.',
            ];

            $this->addLogs($params);

    		return response()->json(['message' => 'success'],200);	
    	}

        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Area Code Update',
            'reference_id' => null,
            'table' => 'area_codes',
            'remarks' => 'Error updating area code.',
        ];

        $this->addLogs($params);

    	return response()->json(['message' => $record->getErrors()]);
    }

    public function status($id)
    {
        $areaCode = AreaCode::find(base64_decode($id));

        if ($areaCode->status == 1) {
        	
        	$areaCode->update(['status' => 0]);

            $params = [
                'user_id' => auth()->user()->id, 
                'activity' => 'Area Code Deactivation',
                'reference_id' => base64_decode($id),
                'table' => 'area_codes',
                'remarks' => 'Success deactivating area code.',
            ];
            
            $this->addLogs($params);

        	return response()->json(['message' => 'Area Code deactivated successfully']);
        }

       	$areaCode->update(['status' => 1]);

        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Area Code Activation',
            'reference_id' => base64_decode($id),
            'table' => 'area_codes',
            'remarks' => 'Success activating area code.',
        ];

        $this->addLogs($params);

        return response()->json(['message' => 'Area Code activated successfully']);
    }
}
