<?php

namespace App\Http\Controllers\Dashboard\Settings\BayanihanPointSetting;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

//Add Models
use App\Models\BayanihanPointSetting;

class UpdateController extends Controller
{
    public function index(Request $request)
    {	
    	$params = $request->all();
        $record = BayanihanPointSetting::find($params['bayanihan_id']);

        if ($record->update($params)) {
            $params = [
                'user_id' => auth()->user()->id, 
                'activity' => 'Bayanihan Point Setting Update',
                'reference_id' => $record->id,
                'table' => 'bayanihan_point_settings',
                'remarks' => 'Success updating admin point setting.',
            ];
            
            $this->addLogs($params);

    		return response()->json(['message' => 'success'],200);	
    	}

        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Bayanihan Point Setting Update',
            'reference_id' => $record->id,
            'table' => 'bayanihan_point_settings',
            'remarks' => 'Failed updating admin point setting.',
        ];
        
        $this->addLogs($params);

        return response()->json(['message' => $record->getErrors()]);
    }

    public function status($id)
    {
        $adminPoint = BayanihanPointSetting::find(base64_decode($id));
        BayanihanPointSetting::where('status',1)->update(['status' => 0]);
        $adminPoint->update(['status' => 1]);
        
        $params = [
                'user_id' => auth()->user()->id, 
                'activity' => 'Bayanihan Point Setting Deactivation',
                'reference_id' => base64_decode($id),
                'table' => 'bayanihan_point_settings',
                'remarks' => 'Bayanihan point setting activated successfully',
        ];
        
        $this->addLogs($params);

        return response()->json(['message' => 'Bayanihan Point Setting activated successfully']);
    }
}
