<?php

namespace App\Http\Controllers\Dashboard\Settings\BayanihanPointSetting;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

//Add Models
use App\Models\BayanihanPointSetting;

class CreateController extends Controller
{
    public function index(Request $request)
    {
    	$params = $request->all();
    	unset($params['bayanihan_id']);
        $params['status'] = $this->getActiveCount();
        $record = new BayanihanPointSetting($params);

    	if (!$record->save()) {
            $params = [
                'user_id' => auth()->user()->id, 
                'activity' => 'Bayanihan Point Settings Register',
                'reference_id' => null,
                'table' => 'bayanihan_point_settings',
                'remarks' => 'Failed registering bayanihan point settings.',
            ];
            
            $this->addLogs($params);

    		return response()->json(['message' => $record->getErrors()]);
    	}

        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Bayanihan Point Settings Register',
            'reference_id' => $record->id,
            'table' => 'bayanihan_point_settings',
            'remarks' => 'Success registering bayanihan point setting.',
        ];

        $this->addLogs($params);

    	return response()->json(['message' => 'success'],200);	
    }
    
    public function getActiveCount()
    {
        $status = BayanihanPointSetting::where('status', 1)->count();
        $result = $status == 0 ? 1 : 0;
        
        return $result;
    }
}
