<?php

namespace App\Http\Controllers\Dashboard\Settings\AdminPointSetting;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

//Add External Classes
use Yajra\Datatables\Datatables;

//Add Models
use App\Models\AdminPointSetting;

class ViewController extends Controller
{
   	public function index()
    {
        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Admin Point Settings View',
            'reference_id' => null,
            'table' => 'admin_point_settings',
            'remarks' => 'Admin Point Settings View Success',
        ];

        $this->addLogs($params);

        return view('dashboard.settings.admin-points.index');
    }

    public function adminPointList()
    {
    	$adminPoints = AdminPointSetting::orderByDesc("status")->get();

        return Datatables::of($adminPoints)
            ->addIndexColumn()
            ->addColumn('qualified_points', function($point){
                return ucwords($point->qualified_points);
            })
            ->addColumn('status', function($point){
               	$status = $point->status == 1 ? 
                    '<i class="mdi mdi-checkbox-blank-circle text-success"></i> Active' :
                    '<i class="mdi mdi-checkbox-blank-circle text-danger"></i> Inactive' ;
                return $status;
            })
            ->addColumn('created_at', function($point){
                return $point->created_at->format('M d,Y h:i:s A');
            })
            ->addColumn('action', function ($point){
                $status = $point->status == 1 ? 'Deactivate' : 'Activate';
                $button = '<a href='.route('admin.pointsettings.edit',base64_encode($point->id)).' id="edit">
                                <button class="btn btn-sm btn-primary mr-1"> 
                                    <i class="mdi mdi-table-edit"></i> Edit
                                </button>
                            </a>';
                $button .= $point->status == 0 ?
                    '<a href='.route('admin.pointsettings.status',base64_encode($point->id)).' id="status">
                        <button class="btn btn-sm btn-success pl-3 pr-3"> 
                            <i class="mdi mdi-check-circle"></i> Activate
                        </button>
                    </a>' : '';

            	$action = '<div style="display:flex">
                                '.$button.'
            			   </div>';
            	return $action;
            })
        	->escapeColumns([])->make(true);
    }

    public function edit($id)
    {
        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Admin Point Settings Edit View',
            'reference_id' => base64_decode($id),
            'table' => 'admin_point_settings',
            'remarks' => 'Admin Point Settings Edit View Success',
        ];
        
        $this->addLogs($params);

        return AdminPointSetting::find(base64_decode($id));
    }
}
