<?php

namespace App\Http\Controllers\Dashboard\Settings\AdminPointSetting;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

//Add Models
use App\Models\AdminPointSetting;

class UpdateController extends Controller
{
    public function index(Request $request)
    {	
    	$params = $request->all();
        $record = AdminPointSetting::find($params['admin_id']);

        if ($record->update($params)) {
            $params = [
                'user_id' => auth()->user()->id, 
                'activity' => 'Admin Point Setting Update',
                'reference_id' => $record->id,
                'table' => 'admin_point_settings',
                'remarks' => 'Success updating admin point setting.',
            ];
            
            $this->addLogs($params);

    		return response()->json(['message' => 'success'],200);	
    	}

        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Admin Point Setting Update',
            'reference_id' => $record->id,
            'table' => 'admin_point_settings',
            'remarks' => 'Failed updating admin point setting.',
        ];
        
        $this->addLogs($params);

        return response()->json(['message' => $record->getErrors()]);
    }

    public function status($id)
    {
        $adminPoint = AdminPointSetting::find(base64_decode($id));
        AdminPointSetting::where('status',1)->update(['status' => 0]);
        $adminPoint->update(['status' => 1]);
        
        $params = [
                'user_id' => auth()->user()->id, 
                'activity' => 'Admin Point Setting Deactivation',
                'reference_id' => base64_decode($id),
                'table' => 'admin_point_settings',
                'remarks' => 'Admin point setting activated successfully',
        ];
        
        $this->addLogs($params);

        return response()->json(['message' => 'Admin Point Setting activated successfully']);
    }
}
