<?php

namespace App\Http\Controllers\Dashboard\Settings\AdminPointSetting;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

//Add Models
use App\Models\AdminPointSetting;

class CreateController extends Controller
{
    public function index(Request $request)
    {
    	$params = $request->all();
    	unset($params['admin_id']);
        $params['status'] = $this->getActiveCount();
        $record = new AdminPointSetting($params);

    	if (!$record->save()) {
            $params = [
                'user_id' => auth()->user()->id, 
                'activity' => 'Admin Point Register',
                'reference_id' => null,
                'table' => 'admin_points_settings',
                'remarks' => 'Failed registering admin point settings.',
            ];
            
            $this->addLogs($params);

    		return response()->json(['message' => $record->getErrors()]);
    	}

        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Admin Point Register',
            'reference_id' => $record->id,
            'table' => 'admin_points_settings',
            'remarks' => 'Success registering admin point setting.',
        ];

        $this->addLogs($params);

    	return response()->json(['message' => 'success'],200);	
    }
    
    public function getActiveCount()
    {
        $status = AdminPointSetting::where('status', 1)->count();
        $result = $status == 0 ? 1 : 0;
        
        return $result;
    }
}
