<?php

namespace App\Http\Controllers\Dashboard\Report\OverallTransaction;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

//Add External Classes
use Yajra\Datatables\Datatables;

// Add Models
use App\Models\Merchant;
use App\Models\Point;

use DB;

class ViewController extends Controller
{
    public function index()
    {   
        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Overall Transactions Report View',
            'reference_id' => null,
            'table' => 'points, promotion_logs, users and merchants',
            'remarks' => 'Overall Transactions Report Success',
        ];

        $this->addLogs($params);
        
    	return view('dashboard.reports.overall-transactions.index');
    }

    public function overallTransactionList(Request $request)
    {   
    	$points = $this->getOverallCustomDateRange($request);

        return Datatables::of($points)
            ->addIndexColumn()
             ->addColumn('rebate', function($point){
                $reb = number_format(floor($point->rebate*100)/100, 2);
                return '₱ '.$reb;
            })
             ->addColumn('advocacy', function($point){
                $ad = number_format(floor($point->advocacy*100)/100, 2);
                return '₱ '.$ad;
            })
             ->addColumn('system', function($point){
                $sys = number_format(floor($point->system*100)/100, 2);
                return '₱ '.$sys;
            })
            ->addColumn('points', function($point){
                return number_format(floor($point->points*100)/100, 2);
            })
            ->addColumn('upline', function($point){
                $full = $point->points / 0.50;
                $upline = ($full * 0.40 );
                return number_format(floor($upline*100)/100, 2);
            })
            ->addColumn('merchant_name', function($point){
                $merchant = Merchant::find($point->merchant_id);
                $photo = (isset($merchant->images[0]->path)) ? 
                            '<img src="'.config('app.AWS_BUCKET_URL').$merchant->images[0]->path.'" class="rounded-circle mr-2" width="40px" height="40px">' : 
                            '<img src='.asset('admin_dashboard/img/default.png').' class="rounded-circle mr-2" width="40px" height="40px">' ;

                return $photo.' '.$merchant->name;
            })
            ->escapeColumns([])->make(true);
    }

    public function getOverallCustomDateRange($request)
    {   
        if (isset($request->date)) {

            $date = explode("-",$request->date);
            $startDate = date('Y-m-d', strtotime($date[0]));
            $endDate = date('Y-m-d', strtotime($date[1]));

             $points = Point::select([
                        'points.merchant_id',
                        DB::raw("SUM(points.system) AS system"), 
                        DB::raw("SUM(points.points) AS points"), 
                        DB::raw("SUM(points.rebate) AS rebate"), 
                        DB::raw("SUM(points.advocacy) AS advocacy"), 
                        DB::raw("(SELECT FORMAT(SUM(promotion_logs.points_amount), 'N', 'en-us') AS pts_payment FROM promotions 
                            LEFT JOIN promotion_logs ON promotion_logs.promo_id = promotions.id 
                            LEFT JOIN merchants ON promotions.merchant_id = merchants.id 
                            WHERE promotions.merchant_id = points.merchant_id 
                            GROUP BY promotions.merchant_id) AS pointAsPayment")
                    ])
                    ->join('merchants','points.merchant_id','merchants.id')
                    ->whereBetween('points.created_at', [$startDate, $endDate])
                    ->groupBy('points.merchant_id')
                    ->get();

        } else {
            $points = Point::select([
                        'points.merchant_id', 
                        DB::raw("SUM(points.system) AS system"), 
                        DB::raw("SUM(points.points) AS points"), 
                        DB::raw("SUM(points.rebate) AS rebate"), 
                        DB::raw("SUM(points.advocacy) AS advocacy"),  
                        DB::raw("(SELECT FORMAT(SUM(promotion_logs.points_amount), 'N', 'en-us') AS pts_payment FROM promotions 
                            LEFT JOIN promotion_logs ON promotion_logs.promo_id = promotions.id 
                            LEFT JOIN merchants ON promotions.merchant_id = merchants.id 
                            WHERE promotions.merchant_id = points.merchant_id 
                            GROUP BY promotions.merchant_id) AS pointAsPayment")
                    ])
                    ->join('merchants','points.merchant_id','merchants.id')
                    ->groupBy('points.merchant_id')
                    ->get();
        }
        return $points;
    }
}
