<?php

namespace App\Http\Controllers\Dashboard\Report\MemberRegistration;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

//Add External Classes
use Yajra\Datatables\Datatables;

// Add Models
use App\Models\Member;
use App\Models\User;

class ViewController extends Controller
{
    public function index()
    {
        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Members Registration Report View',
            'reference_id' => null,
            'table' => 'member_types, users and members',
            'remarks' => 'Members Registration Report Success',
        ];

        $this->addLogs($params);

    	return view('dashboard.reports.members-registration.index');
    }

    public function memberReportList(Request $request)
    {	
    	$members = $this->getMembersCustomDateRange($request);

        return Datatables::of($members)
            ->addIndexColumn()
            ->addColumn('member_id', function($member){
                return $member->member_id;
            })
            ->addColumn('name', function($member){
                $name = ucwords($member->firstname.' '.$member->middlename.' '.$member->lastname);
                $photo = (isset($member->path)) ? 
                            '<img src="'.config('app.AWS_BUCKET_URL').$member->path.'" class="rounded-circle mr-2" width="40px" height="40px">' : 
                            '<img src='.asset('admin_dashboard/img/default.png').' class="rounded-circle mr-2" width="40px" height="40px">' ;
                return $photo.' '.$name;
            })
            ->addColumn('member_type', function($member){
                return $member->member_type;
            })
            ->addColumn('status', function($member){
                $status = $member->registration_status == 'verified' ? 
                    '<i class="mdi mdi-checkbox-blank-circle text-success"></i> Verified' :
                    '<i class="mdi mdi-checkbox-blank-circle text-danger"></i> Not Verified' ;
                return $status;
            })
      		->addColumn('verification_date', function($member){
                return $member->verification_date ? $member->verification_date->format('M d, Y') : '';
            })
            ->addColumn('expiration_date', function($member){
                return $member->expiration_date ? $member->expiration_date->format('M d, Y') : '';
            })
            ->escapeColumns([])->make(true);
    }

    // get custom members date range
    public function getMembersCustomDateRange($request)
    {	
    	if (isset($request->status)) {
    		
    		$date = explode("-",$request->date);
			$startDate = date('Y-m-d', strtotime($date[0]));
			$endDate = date('Y-m-d', strtotime($date[1]));

			if ($request->status != 'all') {
                
                $members = Member::select([
                    'user_images.path',
                    'users.firstname',
                    'users.middlename',
                    'users.lastname',
                    'members.user_id',
                    'members.member_id',
                    'members.registration_status',
                    'members.verification_date',
                    'members.expiration_date',
                    'members.created_at',
                    'member_types.name as member_type',
                ])
                ->leftJoin('member_types','members.member_type_id','member_types.id')
                ->leftJoin('users','members.user_id','users.id')
                ->leftJoin('user_images','members.user_id','user_images.auth_by')
                ->where('members.registration_status', $request->status)
                ->whereBetween('members.created_at', [$startDate, $endDate])
                ->where('users.usertype','member')
                ->get();

            } else {

                $members = Member::select([
                    'user_images.path',
                    'users.firstname',
                    'users.middlename',
                    'users.lastname',
                    'members.user_id',
                    'members.member_id',
                    'members.registration_status',
                    'members.verification_date',
                    'members.expiration_date',
                    'members.created_at',
                    'member_types.name as member_type',
                ])
                ->leftJoin('member_types','members.member_type_id','member_types.id')
                ->leftJoin('users','members.user_id','users.id')
                ->leftJoin('user_images','members.user_id','user_images.auth_by')
                ->whereBetween('members.created_at', [$startDate, $endDate])
                ->where('users.usertype','member')
                ->get();
            }
    	} else {

			$members = Member::select([
                'user_images.path',
                'users.firstname',
                'users.middlename',
                'users.lastname',
                'members.user_id',
                'members.member_id',
                'members.registration_status',
                'members.verification_date',
                'members.expiration_date',
                'members.created_at',
                'member_types.name as member_type',
            ])
            ->leftJoin('member_types','members.member_type_id','member_types.id')
            ->leftJoin('users','members.user_id','users.id')
            ->leftJoin('user_images','members.user_id','user_images.auth_by')
            ->where('users.usertype','member')
            ->latest()
            ->limit(1000)
            ->get();
    	}
    	return $members;
    }
}
