<?php

namespace App\Http\Controllers\Dashboard\Merchant\Wallet;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

//Add External Classes
use Yajra\Datatables\Datatables;

//Add Models
use App\Models\Merchant;
use App\Models\MerchantWallet;

class ViewController extends Controller
{
    public function index()
    {   
        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Merchant Wallet',
            'reference_id' => null,
            'table' => 'merchants',
            'remarks' => 'Success viewing merchants wallet.',
        ];

        $this->addLogs($params);

    	return view('dashboard.merchants.wallets.index');
    }

    public function walletList()
    {
    	$merchants = Merchant::latest()->get();

        return Datatables::of($merchants)
            ->addIndexColumn()
            ->addColumn('merchant_name', function($merchant){
                $name = ucwords($merchant->name);
                $photo = (isset($merchant->images[0]->path)) ? 
                            '<img src="'.config('app.AWS_BUCKET_URL').$merchant->images[0]->path.'" class="rounded-circle mr-2" width="40px" height="40px">' : 
                            '<img src='.asset('admin_dashboard/img/default.png').' class="rounded-circle mr-2" width="40px" height="40px">' ;

                return $photo.' '.$name;   
            })
            ->addColumn('wallet_balance', function($merchant){
                $balance = number_format($merchant->getWalletBalance(),2);
                return '₱ '.$balance;
            })
            ->addColumn('action', function ($merchant){
                $button = '<a href='.route('merchants.wallets.transactions',base64_encode($merchant->id)).' id="view">
                                <button class="btn btn-sm btn-info mr-1"> 
                                    <i class="mdi mdi-eye "></i> View Transactions
                                </button>
                            </a>';
                $button .= '<a href='.route('merchants.wallets.settings',base64_encode($merchant->id)).' id="settings">
                                <button class="btn btn-sm btn-primary mr-1"> 
                                    <i class="mdi mdi-settings"></i> Settings
                                </button>
                            </a>';
                $action = '<div style="display:flex">
                                '.$button.'
                           </div>';
                return $action;
            })
            ->escapeColumns([])->make(true);
    }

    public function settings($id)
    {   
        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Settings Configuration',
            'reference_id' => base64_decode($id),
            'table' => 'merchants',
            'remarks' => 'Success viewing settings configuration.',
        ];

        $this->addLogs($params);

        return Merchant::find(base64_decode($id));
    }

    public function walletTransactions($id)
    {   
        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Wallet Transactions',
            'reference_id' => base64_decode($id),
            'table' => 'merchants',
            'remarks' => 'Success viewing wallet transactions.',
        ];

        $this->addLogs($params);

    	return view('dashboard.merchants.wallets.view',[
            'merchant' => Merchant::find(base64_decode($id))
        ]);
    }

    public function walletTransactionList($id)
    {   
        $wallets = MerchantWallet::where('merchant_id', base64_decode($id))
                    ->latest()
                    ->get();

        return Datatables::of($wallets)
            ->addIndexColumn()
            ->addColumn('amount', function($wallet){
                $amount = number_format($wallet->amount, 2);
                return '₱ '.$amount;
            })
            ->addColumn('description', function($wallet){
                return $wallet->description;
            })
            ->addColumn('created_at', function($wallet){
                return $wallet->created_at->format('M d,Y h:i:s A');
            })
            ->escapeColumns([])->make(true);
    }
}
