<?php

namespace App\Http\Controllers\Dashboard\Merchant\Wallet;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

//Add Models
use App\Models\Merchant;

class UpdateController extends Controller
{
    public function index(Request $request)
    {
    	$params = $request->all();
        $params['mb_amount'] = str_replace(',', '', $request->mb_amount);
    	$record = Merchant::find($params['merchant_id']);

    	if ($record->update($params)) {

    		$params = [
                'user_id' => auth()->user()->id, 
                'activity' => 'Merchant Wallet Setting Update',
                'reference_id' => $record->id,
                'table' => 'merchants',
                'remarks' => 'Success updating merchant wallet setting.',
            ];
            
            $this->addLogs($params);

    		return response()->json(['message' => 'success'],200);	
    	}

    	$params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Merchant Wallet Setting Update',
            'reference_id' => $record->id,
            'table' => 'merchants',
            'remarks' => 'Failed updating merchant wallet setting.',
        ];
        
        $this->addLogs($params);

    	return response()->json(['message' => $record->getErrors()]);
    }
}
