<?php

namespace App\Http\Controllers\Dashboard\Merchant\Wallet;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

//Add Models
use App\Models\MerchantWallet;

class CreateController extends Controller
{
    public function index(Request $request, $id)
    {
    	$params = $request->all();
        $params['amount'] = str_replace(',', '', $request->amount);
    	$params['merchant_id'] = base64_decode($id);
    	$wallet = new MerchantWallet($params);

    	if ($wallet->save()) {

            $params = [
                'user_id' => auth()->user()->id, 
                'activity' => 'Top-up Wallet',
                'reference_id' => $wallet->id,
                'table' => 'merchant_wallets',
                'remarks' => 'Successfully top-up wallet',
            ];

            $this->addLogs($params);

    		return response()->json([
                    'balance' => number_format($wallet->merchant->getWalletBalance(),2)
                ]);
    	}

        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Top-up Wallet',
            'reference_id' => $wallet->id,
            'table' => 'merchant_wallets',
            'remarks' => 'Failed top-up wallet',
        ];
        
        $this->addLogs($params);

    	return response()->json(['error' => $wallet->getErrors()]);
    }
}
