<?php

namespace App\Http\Controllers\Dashboard\Merchant;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

//Add Models
use App\Models\MerchantAgreement;
use App\Models\PaymentMethod;
use App\Models\Merchant;

use Redirect;
use DB;

class UpdateController extends Controller
{
    public function index(Request $request, $id)
    {   
        DB::beginTransaction();

    	$params = $request->all();
        $params['mb_amount'] = 0;
        $params['mb_percent'] = 0;
    	$merchant = Merchant::find(base64_decode($id));
        $oldMerchantIsMobile = $merchant->is_mobile;
    	if ($merchant->update($params)) {

            if ($oldMerchantIsMobile == 1) {
                if (isset($request->is_mobile)) {

                    $merchantAgreement = MerchantAgreement::find($merchant->merchantAgreement->id);
                    if (!$merchantAgreement->update($params)) {
                        // Rollback and then redirect & back to form with errors
                        DB::rollback();

                        $params = [
                            'user_id' => auth()->user()->id, 
                            'activity' => 'Update Merchant',
                            'reference_id' => null,
                            'table' => 'merchants and merchant_agreements',
                            'remarks' => 'Failed to add new merchant',
                        ];

                        $this->addLogs($params);

                        return Redirect::route('merchants.edit', $id)
                            ->withErrors($merchantAgreement->getErrors())
                            ->withInput();
                    }

                    //delete payment methods before updating
                    $merchantAgreement->paymentMethods()->delete();
                    $this->storePaymentMethod($request->payment_method, $merchantAgreement->id);

                } else {

                    //Delete paymentMethods and merchantAgreement
                    $merchant->merchantAgreement->paymentMethods()->delete();
                    $merchant->merchantAgreement->delete();
                    $merchant->update(['is_mobile' => 0]);
                }

            } else {

                if (isset($request->is_mobile)) {
                    // Add Agreement
                    $params['merchant_id'] = $merchant->id;
                    $merchantAgreement = new MerchantAgreement($params);
                    if (!$merchantAgreement->save()) {
                        // Rollback and then redirect & back to form with errors
                        DB::rollback();

                        $params = [
                            'user_id' => auth()->user()->id, 
                            'activity' => 'Register Merchant',
                            'reference_id' => null,
                            'table' => 'merchants and merchant_agreements',
                            'remarks' => 'Failed to add new merchant',
                        ];

                        $this->addLogs($params);

                        return Redirect::route('merchants.edit', $id)
                            ->withErrors($merchantAgreement->getErrors())
                            ->withInput();
                    }
                    // Store Payment Method
                    $this->storePaymentMethod($request->payment_method, $merchantAgreement->id);
                }
            }
    		
            //SAVE IMAGE TO S3
            $this->storeMerchantImage($request, $merchant->id);

            DB::commit();

            $params = [
                'user_id' => auth()->user()->id, 
                'activity' => 'Update Merchant',
                'reference_id' => null,
                'table' => 'logs',
                'remarks' => 'Successfully updated new merchant',
            ];

            $this->addLogs($params);
            
			return Redirect::route('merchants')->with(['success' => 'Successfully updated new merchant']);
    	}

    	return Redirect::route('merchants.edit', $id)
	        ->withErrors($merchant->getErrors())
	        ->withInput();
    }

    public function storePaymentMethod($payment_method, $merchant_agreement_id)
    {
        foreach ($payment_method as $method) {
            $params = [
                'merchant_agreement_id' => $merchant_agreement_id,
                'name' => $method,
            ];

            PaymentMethod::create($params);
        }
    }
}
