<?php

namespace App\Http\Controllers\Dashboard\Merchant\Settings;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

//Add Models
use App\Models\PromoMemberType;
use App\Models\PromoMember;
use App\Models\Promotion;

class UpdateController extends Controller
{
    public function index(Request $request, $id)
    {	
        $request->merge([
            'merchant_id'       => base64_decode($id),
            'points_as_payment' => ($request->type == 'points_of_payment') ? 1 : 0,
            'quantity'          => str_replace(',', '', $request->quantity),
            'points_required'   => str_replace(',', '', $request->points_required),
            'price'             => str_replace(',', '', $request->price),
            'allocation_amount' => str_replace(',', '', $request->allocation_amount),
        ]);

        $params = $request->except(['status']);        
        $promo = Promotion::find($params['promo_id']);

        // get old fields
        $oldIsCustom = $promo->is_custom;
        $oldCustomType = $promo->custom_type;

    	if ($promo->update($params)) {

            if ($oldIsCustom == 1) {
                if ($request->is_custom == 1) {

                    if ($request->custom_type == 'promo_members') {

                        if ($oldCustomType == 'promo_member_types') {
                            // delete old value
                            $promo->promoMemberTypes()->delete();
                        }
                        
                        //delete promo members before updating
                        $promo->promoMembers()->delete();
                        $promo->update(['custom_type' => 'promo_members']);
                        $this->storePromoMember($promo->id, $request->member_ids);

                    } else {

                        if ($oldCustomType == 'promo_members') {
                            // delete old value
                            $promo->promoMembers()->delete();
                        }
                        
                        //delete promo member types before updating
                        $promo->promoMemberTypes()->delete();
                        $promo->update(['custom_type' => 'promo_member_types']);
                        $this->storePromoMemberType($promo->id, $request->member_types);
                    }

                } else {

                    if ($oldCustomType == 'promo_members') {
                        //delete promo members
                        $promo->promoMembers()->delete();
                        $promo->update(['is_custom' => 0, 'custom_type' => null]);

                    } else {
                        //delete promo member types
                        $promo->promoMemberTypes()->delete();
                        $promo->update(['is_custom' => 0, 'custom_type' => null]);
                    }
                }
            } else {

                if ($request->is_custom == 1) {
                    if ($request->custom_type == 'promo_members') {
                        $this->storePromoMember($promo->id, $request->member_ids);
                    } else {
                        $this->storePromoMemberType($promo->id, $request->member_types);
                    }
                }
            }

            //SAVE IMAGE TO S3
            $this->storePromotionImage($request, $promo->id);
            
            $params = [
                'user_id' => auth()->user()->id, 
                'activity' => 'Promotion Registration',
                'reference_id' => $promo->id,
                'table' => 'promotions',
                'remarks' => 'Success registering promotion.',
            ];
            
            $this->addLogs($params);

    		return response()->json(['message' => 'success']);
    	}

        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Promotion Registration',
            'reference_id' => null,
            'table' => 'promotions',
            'remarks' => 'error registering promotion.',
        ];

        $this->addLogs($params);

    	return response()->json(['message' => $promo->getErrors()]);
    }

    public function storePromoMember($promo_id, $member_ids)
    {
        foreach ($member_ids as $member_id) {
            $params = [
                'promo_id'  => $promo_id,
                'member_id' => $member_id,
            ];

            PromoMember::create($params);
        }
    }

    public function storePromoMemberType($promo_id, $member_types)
    {
        foreach ($member_types as $member_type_id) {
            $params = [
                'promo_id'       => $promo_id,
                'member_type_id' => $member_type_id,
            ];

            PromoMemberType::create($params);
        }
    }
}
