<?php

namespace App\Http\Controllers\Dashboard\Merchant\Settings;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

//Add Models
use App\Models\PromoMemberType;
use App\Models\PromoMember;
use App\Models\PointSetting;
use App\Models\Promotion;

class CreateController extends Controller
{
    public function index(Request $request, $id)
    {	
        $request->merge([
            'merchant_id'       => base64_decode($id),
            'points_as_payment' => ($request->type == 'points_of_payment') ? 1 : 0,
            'quantity'          => str_replace(',', '', $request->quantity),
            'points_required'   => str_replace(',', '', $request->points_required),
            'price'             => str_replace(',', '', $request->price),
            'allocation_amount' => str_replace(',', '', $request->allocation_amount),
        ]);

        $params = $request->except(['status']);        
    	$record = new Promotion($params);

    	if ($record->save()) {

            if ($request->is_custom == 1) {
                if ($request->custom_type == 'promo_members') {
                    foreach ($request->member_ids as $member_id) {
                        $params = [
                            'promo_id'  => $record->id,
                            'member_id' => $member_id,
                        ];

                        PromoMember::create($params);
                    }
                } else {
                    foreach ($request->member_types as $member_type_id) {
                        $params = [
                            'promo_id'       => $record->id,
                            'member_type_id' => $member_type_id,
                        ];

                        PromoMemberType::create($params);
                    }
                }
            }

            //SAVE IMAGE TO S3
            $this->storePromotionImage($request, $record->id);
            
            $params = [
                'user_id' => auth()->user()->id, 
                'activity' => 'Promotion Registration',
                'reference_id' => $record->id,
                'table' => 'promotions',
                'remarks' => 'Success registering promotion.',
            ];
            
            $this->addLogs($params);

    		return response()->json(['message' => 'success']);
    	}

        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Promotion Registration',
            'reference_id' => null,
            'table' => 'promotions',
            'remarks' => 'error registering promotion.',
        ];

        $this->addLogs($params);

    	return response()->json(['message' => $record->getErrors()]);
    }

    public function setupRebate(Request $request, $id)
    {
        $params = $request->all();
        $params['merchant_id'] = base64_decode($id);

        $settings = PointSetting::where('merchant_id', base64_decode($id))->whereStatus(1)->first();

        if (isset($settings)) {
            $settings->update(['status' => 0]);
        } 
            
        $record = new PointSetting($params);

        if (!$record->save()) {
            $params = [
                'user_id' => auth()->user()->id, 
                'activity' => 'Setup Rebates Register',
                'reference_id' => null,
                'table' => 'points_settings',
                'remarks' => 'Failed registering setup rebate point settings.',
            ];
            
            $this->addLogs($params);

            return response()->json(['message' => $record->getErrors()]);
        }

        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Point Setup Rebates Register',
            'reference_id' => $record->id,
            'table' => 'points_settings',
            'remarks' => 'Success registering setup rebate point settings.',
        ];

        $this->addLogs($params);
    
        return response()->json(['message' => 'success'],200);  
    }
}
