<?php

namespace App\Http\Controllers\Dashboard\Merchant\Product;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

//Add Models
use App\Models\Product;

class UpdateController extends Controller
{
    public function index(Request $request)
    {
    	$activity = base64_decode($request->code) == 1 ? 'Approved' : 'Rejected';

    	for ($i=0; $i < count($request->product); $i++) { 

    		$product = Product::where('id',base64_decode($request->product[$i]))->update([
                'status'        => base64_decode($request->code),
                'approved_by'   => auth()->user()->id
            ]);

    		$params = [
	            'user_id' => auth()->user()->id, 
	            'activity' => 'Product '.$activity,
	            'reference_id' => base64_decode($request->product[$i]),
	            'table' => 'promotions',
	            'remarks' => 'Successfully '.$activity.' Product',
	        ];

	        $this->addLogs($params);
    	}

    	return response()->json(['message' => 'success']);
    }
}
