<?php

namespace App\Http\Controllers\Dashboard\Merchant\Product;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

//Add Models
use App\Models\Product;

class CreateController extends Controller
{
    public function index(Request $request)
    {
        $request->merge([
            'item_code'     => $this->generateItemCode(),
            'price'         => str_replace(',', '', $request->price),
            'auth_by'       => auth()->user()->id,
        ]);

    	$params = $request->all();
        $record = new Product($params);

        if (!$record->save()) {

            $params = [
                'user_id' => auth()->user()->id, 
                'activity' => 'Product Register',
                'reference_id' => null,
                'table' => 'products',
                'remarks' => 'Failed registering product.',
            ];
            
            $this->addLogs($params);

            return response()->json(['message' => $record->getErrors()]);
        }

        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Product Register',
            'reference_id' => $record->id,
            'table' => 'products',
            'remarks' => 'Success registering product.',
        ];

        $this->addLogs($params);

        //SAVE IMAGE TO S3
        $this->storeProductImage($request, $record->id);     

        return response()->json(['message' => 'success'],200);  
    }

    // Generate Item Code
    public function generateItemCode()
    {   
        $code = $this->generateNumericCode(10);
        $driver = Product::where('item_code','LIKE','%'.$code.'%')->first();

        if (isset($driver)) {
            $code = $this->generateNumericCode(10);
        }    

        return 'IT:'.$this->getProductCount().':'.$code;
    }

    // Generate 10 digits Item Code
    public function generateNumericCode($limit)
    {
        $code = '';
        for($i = 0; $i < $limit; $i++) { 
            $code .= mt_rand(0, 9); 
        }

        return $code;
    }

    public function getProductCount()
    {
        $productCount = Product::count();

        return $productCount == 0 ? $productCount : $productCount + 1;
    }
}