<?php

namespace App\Http\Controllers\Dashboard\Merchant\Order;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

//Add Models
use App\Models\TransactionOrder;
use App\Models\Order;
use App\Models\Driver;

class UpdateController extends Controller
{
    public function index(Request $request, $id)
    {
    	$transactionOrder = TransactionOrder::find(base64_decode($id));
        
        $orders_data = array(
            "function" => "ORDERS",
            "function_id" => (string)$transactionOrder->user_id,
            "id" => str_replace("REF#:","",$transactionOrder->reference_id),
            "merchant" => array(
                "id" => (string)$transactionOrder->establishment->id,
                "name" => $transactionOrder->establishment->name,
                "location" => array(
                    "latitude" => (double)$transactionOrder->establishment->latitude,
                    "longitude" => (double)$transactionOrder->establishment->longitude,
                    "address" => $transactionOrder->establishment->address
                )
            ),
            "deliveryLocation" => array(
                "latitude" => (double)$transactionOrder->latitude,
                "longitude" => (double)$transactionOrder->longitude,
                "address" => $transactionOrder->address
            ),
            "totalItems" => (int)$transactionOrder->orders->sum('quantity'),
            "totalPrice" => null,
            "status" => strtoupper($request->status),
            "dateOrdered" => $transactionOrder->created_at->format("Y-m-d H:i:s")
        );

        $order_details_data = array(
            "function" => "ORDER-DETAIL",
            "function_id" => str_replace("REF#:","",$transactionOrder->reference_id),
            "id" => str_replace("REF#:","",$transactionOrder->reference_id),
            "merchant" => $orders_data["merchant"],
            "deliveryLocation" => $orders_data["deliveryLocation"],
            "cashOnHand" => (double)$transactionOrder->cash_on_hand,
            "dateOrdered" => $transactionOrder->created_at->format("Y-m-d H:i:s"),
            "mode" => "ASAP",
            "notes" => $transactionOrder->notes,
            "deliveryFee" => (double)$request->delivery_amount,
            "paymentMethod" => str_replace(" ","",strtoupper($transactionOrder->payment_method)),
            "items" => null
        );

        $total_price = 0;
        foreach ($transactionOrder->orders as $key => $order) {
            $total = $order->product->price * $order->quantity;
            $total_price += $total;
        }

        $orders_data["totalPrice"] = (double)$total_price;

        if($transactionOrder->driver_id != null) {
            $driver = Driver::where('id', $transactionOrder->driver_id)->first();

            $order_details_data["driver"] = [
                "vehicle" => [
                    "id" => (string)$driver->vehicle->id,
                    "make" => $driver->vehicle->model,
                    "plateNumber" => $driver->vehicle->plate_number
                ],
                "id" => (string)$driver->id,
                "cardNumber" => null,
                "firstName" => $driver->user->firstname,
                "mi" => (isset($driver->user->middlename[0])) ? $driver->user->middlename[0] : null,
                "lastName" => $driver->user->lastname,
                "contactNumber" => $driver->contact_number,
                "emailAddress" => $driver->user->email,
                "address" => null,
                "username" => $driver->user->username,
                "imageUrl" => isset($driver->image->url) ? $driver->image->url : null
            ];
        } 

        if ($request->status == 'cancelled') {
            $transactionOrder->update(['status' => 'cancelled']);

            //Emit Socket ORDERS
            $orders_data["status"] = strtoupper($request->status);
            $this->emitSocket($orders_data);

            //Emit Socket ORDERS
            $order_details_data["status"] = strtoupper($request->status);
            $this->emitSocket($order_details_data);

        } else {
            if ($transactionOrder->status == 'pending') {
                $transactionOrder->update([
                    'driver_id' => $request->driver_id,
                    'status'    => 'pending_customer',
                    'delivery_amount' => $request->delivery_amount
                ]);

                //Emit Socket ORDERS
                $orders_data["status"] = "PENDING_CUSTOMER";
                $this->emitSocket($orders_data);

                //Emit Socket ORDERS
                $order_details_data["status"] = "PENDING_CUSTOMER";
                $this->emitSocket($order_details_data);

            } elseif ($transactionOrder->status == 'accepted') {
                $transactionOrder->update([
                    'driver_id' => $request->driver_id,
                    'status' => 'prepared'
                ]);


                if($transactionOrder->payment_method == "COD") {
                    $driver_order_data = array(
                        "function" => "DELIVERIES",
                        "function_id" => (string)$request->driver_id,
                        "id" => str_replace("REF#:","",$transactionOrder->reference_id),
                        "merchant" => $orders_data["merchant"],
                        "recipient" => array(
                            "id" => (string)$transactionOrder->user->id,
                            "firstName" => $transactionOrder->user->firstname,
                            "mi" => isset($transactionOrder->user->middlename[0]) ? $transactionOrder->user->middlename[0] : "",
                            "lastName" => $transactionOrder->user->lastname,
                            "contactNumber" => $transactionOrder->user->member->mobile_number,
                            "emailAddress" => $transactionOrder->user->email,
                            "address" => $transactionOrder->user->member->address,
                            "username" => $transactionOrder->user->username,
                            "imageUrl" => isset($transactionOrder->user->images[0]->path) ? $transactionOrder->user->images[0]->url : null, 
                        ),
                        "deliveryLocation" => $orders_data["deliveryLocation"],
                        "totalItems" => (int)$transactionOrder->orders->sum('quantity'),
                        "totalPrice" => $orders_data["totalPrice"],
                        "status" => "PREPARED",
                        "dateOrdered" => $transactionOrder->created_at->format("Y-m-d H:i:s")
                    );

                    //Emit Socket for Driver DELIVIERIES
                    $this->emitSocket($driver_order_data);
                }

                //Emit Socket ORDERS
                $orders_data["status"] = "PREPARED";
                $this->emitSocket($orders_data);

                 //Emit Socket ORDERS
                $order_details_data["status"] = "PREPARED";
                $this->emitSocket($order_details_data);

            } elseif ($transactionOrder->status == 'prepared') {
                $transactionOrder->update([
                    'driver_id' => $request->driver_id,
                    'status' => 'completed'
                ]);

                //Emit Socket ORDERS
                $orders_data["status"] = "COMPLETED";
                $this->emitSocket($orders_data);

                 //Emit Socket ORDERS
                $order_details_data["status"] = "COMPLETED";
                $this->emitSocket($order_details_data);
            }
        }

    	return response()->json(['message' => 'Transaction Order updated Successfully!']);
    }

    public function updateQuantity(Request $request, $id) {
        $order = Order::find(base64_decode($id));
        $order->quantity = $request->quantity;
        $order->save();
        return response()->json(['message' => 'Order updated!']);
    }

    public function updateStatus($id) {
        $order = Order::find(base64_decode($id));
        $order->delete();
        return response()->json(['message' => 'Order deleted!']);
    }
}
