<?php

namespace App\Http\Controllers\Dashboard\Merchant\Establishment;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

//Add Models
use App\Models\Establishment;

class UpdateController extends Controller
{
    public function index(Request $request)
    {	
    	$params = $request->all();
        $record = Establishment::find($params['establishment_id']);

        if ($record->update($params)) {
            $params = [
                'user_id' => auth()->user()->id, 
                'activity' => 'Establishment Update',
                'reference_id' => $record->id,
                'table' => 'establishments',
                'remarks' => 'Success updating establishment.',
            ];

            $this->addLogs($params);

            //SAVE IMAGE TO S3
            $this->storeEstablishmentImage($request, $record->id);

    		return response()->json(['message' => 'success'],200);	
    	}

        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Establishment Update',
            'reference_id' => null,
            'table' => 'establishments',
            'remarks' => 'Error updating establishment.',
        ];

        $this->addLogs($params);

    	return response()->json(['message' => $record->getErrors()]);
    }

    public function status($id)
    {
        $establishment = Establishment::find(base64_decode($id));

        if ($establishment->status == 1) {
        	if($establishment->merchant_agreement) {
                return response()->json(['message' => 'Establishment in use. Cannot Deactivate'], 409);
            }
        	$establishment->update(['status' => 0]);

            $params = [
                'user_id' => auth()->user()->id, 
                'activity' => 'Establishment Deactivation',
                'reference_id' => base64_decode($id),
                'table' => 'specialities',
                'remarks' => 'Success deactivating establishment.',
            ];
            
            $this->addLogs($params);

        	return response()->json(['message' => 'Establishment deactivated successfully']);
        }

       	$establishment->update(['status' => 1]);

        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Establishment Activation',
            'reference_id' => base64_decode($id),
            'table' => 'specialities',
            'remarks' => 'Success activating establishment.',
        ];

        $this->addLogs($params);

        return response()->json(['message' => 'Establishment activated successfully']);
    }
}
