<?php

namespace App\Http\Controllers\Dashboard\Merchant\Establishment;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

//Add Models
use App\Models\Establishment;

class CreateController extends Controller
{
    public function index(Request $request, $id)
    {
    	$params = $request->all();
    	$params['merchant_id'] = base64_decode($id);
        $record = new Establishment($params);

    	if (!$record->save()) {
            $params = [
                'user_id' => auth()->user()->id, 
                'activity' => 'Establishment Registration',
                'reference_id' => null,
                'table' => 'establishments',
                'remarks' => 'Error registering establishment.',
            ];

            $this->addLogs($params);

    		return response()->json(['message' => $record->getErrors()]);
    	}

        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Establishment Registration',
            'reference_id' => $record->id,
            'table' => 'establishments',
            'remarks' => 'Success registering establishment.',
        ];

        $this->addLogs($params);

        //SAVE IMAGE TO S3
        $this->storeEstablishmentImage($request, $record->id);     
           
    	return response()->json(['message' => 'success'],200);	
    }
}
