<?php

namespace App\Http\Controllers\Dashboard\Merchant\Driver;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

//Add Models
use App\Models\Driver;
use App\Models\User;

use Redirect;
use Hash;
use DB;

class UpdateController extends Controller
{	
	public function index(Request $request, $id)
    {
    	DB::beginTransaction();

    	$userParams = $request->only(['firstname','middlename','lastname','email']);
    	$user = User::find(base64_decode($id));

    	if ($user->update($userParams)) {

    		$params = $request->only(['image','contact_number','vehicle_id','merchant_id']);
            $driver = Driver::where('user_id', base64_decode($id))->first();

			if (!$driver->update($params)) {
				// Rollback and then redirect & back to form with errors
				DB::rollback();

				$params = [
                    'user_id' => auth()->user()->id, 
                	'activity' => 'Merchant Driver Registration',
                    'reference_id' => null,
                	'table' => 'users and drivers',
                    'remarks' => 'Error registering merchant drivers.',
                ];

                $this->addLogs($params);

				return Redirect::route('merchants.drivers.edit', $id)
			        ->withErrors($driver->getErrors())
			        ->withInput();
			}
			
            //SAVE IMAGE TO S3
            $this->storeDriverImage($request, $driver->id);
            
            //ASSIGN ROLE
            $this->assignRole($user);

			DB::commit();

			$params = [
                'user_id' => auth()->user()->id, 
                'activity' => 'Merchant Driver Registration',
                'reference_id' => $driver->id,
                'table' => 'users and drivers',
                'remarks' => 'Successfully registered merchant drivers.',
            ];

            $this->addLogs($params);

			return Redirect::route('merchants.drivers')
						->with(['success' => 'Successfully updated merchant drivers']);
    	}

    	return Redirect::route('merchants.drivers.edit', $id)
				        ->withErrors($user->getErrors())
				        ->withInput();
    }

    public function status($id)
    {
        $user = User::find(base64_decode($id));

        if ($user->status == 1) {
        	
        	$user->update(['status' => 0]);

            $params = [
                'user_id' => auth()->user()->id, 
                'activity' => 'Driver Deactivation',
                'reference_id' => base64_decode($id),
                'table' => 'users',
                'remarks' => 'Success deactivating driver.',
            ];
            
            $this->addLogs($params);

        	return response()->json(['message' => 'Driver deactivated successfully']);
        }

       	$user->update(['status' => 1]);

        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Driver Activation',
            'reference_id' => base64_decode($id),
            'table' => 'users',
            'remarks' => 'Success activating driver.',
        ];

        $this->addLogs($params);

        return response()->json(['message' => 'Driver activated successfully']);
    }

    public function resetPassword($id)
    {
        $user = User::find(base64_decode($id));
        $user->update(['password' => Hash::make('pplus2020')]);

        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'User Reset Password',
            'reference_id' => base64_decode($id),
            'table' => 'users',
            'remarks' => 'Success driver reset password.',
        ];

        $this->addLogs($params);

        // Should send an email/text that his password is reset!
        // code...

        return response()->json(['message' => 'Driver Password reset successfully']);
    }
}
