<?php

namespace App\Http\Controllers\Dashboard\Merchant\Driver;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

//Add Models
use App\Models\Driver;
use App\Models\User;

use Redirect;
use Hash;
use DB;

class CreateController extends Controller
{
    public function index(Request $request)
    {
    	DB::beginTransaction();

    	$request->merge([
    		'password' => Hash::make('pplus2020'),
    		'usertype' => 'driver',
    	]);
    	$userParams = $request->only(['firstname','middlename','lastname','username','email','password','usertype']);
    	$user = new User($userParams);

    	if ($user->save()) {

    		$params = $request->only(['image','contact_number','vehicle_id','merchant_id']);
    		$params['user_id'] = $user->id;
			$params['professional_id'] = $this->generateProfessionalId();
			$driver = new Driver($params);

			if (!$driver->save()) {
				// Rollback and then redirect & back to form with errors
				DB::rollback();

				$params = [
                    'user_id' => auth()->user()->id, 
                	'activity' => 'Merchant Driver Registration',
                    'reference_id' => null,
                	'table' => 'users and drivers',
                    'remarks' => 'Error registering merchant drivers.',
                ];

                $this->addLogs($params);

				return Redirect::route('merchants.drivers.add')
			        ->withErrors($driver->getErrors())
			        ->withInput();
			}
			
            //SAVE IMAGE TO S3
            $this->storeDriverImage($request, $driver->id);
            
            //ASSIGN ROLE
            $this->assignRole($user);

			DB::commit();

			$params = [
                'user_id' => auth()->user()->id, 
                'activity' => 'Merchant Driver Registration',
                'reference_id' => $user->id,
                'table' => 'users and drivers',
                'remarks' => 'Successfully registered merchant drivers.',
            ];

            $this->addLogs($params);

			return Redirect::route('merchants.drivers')
						->with(['success' => 'Successfully added merchant drivers']);
    	}

    	return Redirect::route('merchants.drivers.add')
				        ->withErrors($user->getErrors())
				        ->withInput();
    }

    // Generate Professional ID
    public function generateProfessionalId()
    {   
        $code = $this->generateAlphaNumeric(4);
        $driver = Driver::where('professional_id','LIKE','%'.$code.'%')->first();

        if (isset($driver)) {
            $code = $this->generateAlphaNumeric(4);
        }    

        return 'D:'.$this->getDriverCount().':'.$code;
    }

    // Generate Alpha Numberic
    public function generateAlphaNumeric($limit)
    {
        $code = substr(base_convert(sha1(uniqid(mt_rand())), 16, 36), 0, $limit);

        return strtoupper($code);
    }

    public function getDriverCount()
    {
        $driverCount = Driver::count();

        return $driverCount == 0 ? $driverCount : $driverCount + 1;
    }
}
