<?php

namespace App\Http\Controllers\Dashboard\Merchant\Doctor;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

//Add Models
use App\Models\DoctorPaymentMethod;
use App\Models\DoctorSpeciality;
use App\Models\Doctor;
use App\Models\User;

use Redirect;
use Hash;
use DB;

class UpdateController extends Controller
{
	public function index(Request $request, $id)
    {
    	DB::beginTransaction();

    	$request->merge([
    		'minimum_consultation_fee' => str_replace(',', '', $request->minimum_consultation_fee),
    		'maximum_consultation_fee' => str_replace(',', '', $request->maximum_consultation_fee),
    	]);

    	$userParams = $request->only(['firstname','middlename','lastname','email']);
    	$user = User::find(base64_decode($id));

    	if ($user->update($userParams)) {

    		$params = $request->only(['prefix','contact_number','minimum_consultation_fee','maximum_consultation_fee']);
            $doctor = Doctor::where('user_id', base64_decode($id))->first();

			if (!$doctor->update($params)) {
				// Rollback and then redirect & back to form with errors
				DB::rollback();

				$params = [
                    'user_id' => auth()->user()->id, 
                	'activity' => 'Doctors Registration',
                    'reference_id' => null,
                	'table' => 'users and doctors',
                    'remarks' => 'Error updating doctor.',
                ];

                $this->addLogs($params);

				return Redirect::route('merchants.doctors.edit', $id)
			        ->withErrors($doctor->getErrors())
			        ->withInput();
			}
			
			// delete old speciliaties
			$doctor->doctorSpecialities()->delete();
			$this->storeDoctorSpecialities($request->doctor_specialities, $doctor->id);
			
			// delete old speciliaties
			$doctor->doctorPaymentMethods()->delete();
			$this->storePaymentMethods($request->doctor_payment_methods, $doctor->id);

            //SAVE IMAGE TO S3
            $this->storeDoctorImage($request, $doctor->id);
            
            //ASSIGN ROLE
            $this->assignRole($user);

			DB::commit();

			$params = [
                'user_id' => auth()->user()->id, 
                'activity' => 'Doctors Update',
                'reference_id' => $user->id,
                'table' => 'users and doctors',
                'remarks' => 'Successfully updated doctor.',
            ];

            $this->addLogs($params);

			return Redirect::route('merchants.doctors')
						->with(['success' => 'Successfully updated doctor']);
    	}

        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Doctors Update',
            'reference_id' => base64_decode($id),
            'table' => 'users and doctors',
            'remarks' => 'Failed to update doctor.',
        ];

        $this->addLogs($params);

    	return Redirect::route('merchants.doctors.edit', $id)
				        ->withErrors($user->getErrors())
				        ->withInput();
    }

    public function status($id)
    {
        $user = User::find(base64_decode($id));

        if ($user->status == 1) {
            
            $user->update(['status' => 0]);

            $params = [
                'user_id' => auth()->user()->id, 
                'activity' => 'Doctor Deactivation',
                'reference_id' => base64_decode($id),
                'table' => 'users',
                'remarks' => 'Success deactivating doctor.',
            ];
            
            $this->addLogs($params);

            return response()->json(['message' => 'Doctor deactivated successfully']);
        }

        $user->update(['status' => 1]);

        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Doctor Activation',
            'reference_id' => base64_decode($id),
            'table' => 'users',
            'remarks' => 'Success activating doctor.',
        ];

        $this->addLogs($params);

        return response()->json(['message' => 'Doctor activated successfully']);
    }

    public function storeDoctorSpecialities($doctor_specialities, $doctorId)
    {
    	foreach ($doctor_specialities as $speciality) {
				
			$params = [
                'doctor_id' 	=> $doctorId,
                'speciality_id' => $speciality,
            ];

			DoctorSpeciality::create($params);
		}
    }

    public function storePaymentMethods($doctor_payment_methods, $doctorId)
    {
    	foreach ($doctor_payment_methods as $payment) {
			
			$params = [
                'doctor_id' => $doctorId,
                'name' 		=> $payment,
            ];

			DoctorPaymentMethod::create($params);
		}
    }
}
