<?php

namespace App\Http\Controllers\Dashboard\Merchant\Doctor\Schedule;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

//Add Models
use App\Models\DoctorSchedule;
use App\Models\Doctor;

class ViewController extends Controller
{
    public function index($id)
    {	
    	$params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Doctor Schedules Add',
            'reference_id' => null,
            'table' => 'doctor_schedules',
            'remarks' => 'Doctor Schedules Add Success',
        ];

        $this->addLogs($params);

    	return view('dashboard.merchants.doctors.schedules.add',[
    		'doctor' => $this->getDoctor($id)
    	]);       
    }

    public function edit($id)
    {	
    	$doctor = $this->getDoctor($id);
        $doctor['schedules'] = $this->getDoctorSchedules($doctor->id);

    	$params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Doctor Schedules Edit',
            'reference_id' => null,
            'table' => 'doctor_schedules',
            'remarks' => 'Doctor Schedules Edit Success',
        ];

        $this->addLogs($params);

    	return view('dashboard.merchants.doctors.schedules.edit',[
    		'doctor' => $doctor
    	]);
    }

    // get doctor
    public function getDoctor($id)
    {
    	$doctor = Doctor::select([
                    'doctors.id',
                    'doctors.bio',
                    'doctors.prefix',
                    'doctors.professional_id',
                    'doctors.contact_number',
                    'doctors.minimum_consultation_fee',
                    'doctors.maximum_consultation_fee',
                    'doctor_images.path',
                    'doctor_schedules.doctor_id',
                    'users.firstname',
                    'users.middlename',
                    'users.lastname',
                    'users.email',
                    'users.username',
                    'users.usertype',
                    'users.status',
                ])
                ->leftJoin('doctor_images', 'doctor_images.doctor_id', 'doctors.id')
                ->leftJoin('doctor_schedules', 'doctor_schedules.doctor_id', 'doctors.id')
                ->leftJoin('users', 'users.id', 'doctors.user_id')
                ->where('doctors.id', base64_decode($id))
                ->first();

        $doctor['path'] = isset($doctor->path) ? config('app.AWS_BUCKET_URL').$doctor->path : asset("admin_dashboard/img/default.png");

        return $doctor;
    }

    // get schedules
    public function getDoctorSchedules($id)
    {
    	$schedule = DoctorSchedule::where('doctor_id', $id)->first();

    	$schedules = (Object)[
    		'monday'	=> $this->formatScheduleTime($schedule->monday),
    		'tuesday' 	=> $this->formatScheduleTime($schedule->tuesday),
    		'wednesday' => $this->formatScheduleTime($schedule->wednesday),
    		'thursday' 	=> $this->formatScheduleTime($schedule->thursday),
    		'friday' 	=> $this->formatScheduleTime($schedule->friday),
    		'saturday' 	=> $this->formatScheduleTime($schedule->saturday),
    		'sunday' 	=> $this->formatScheduleTime($schedule->sunday),
    	];

    	return $schedules;
    }

    // format schedule time
    public function formatScheduleTime($time)
    {
        $amFrom = substr($time, 1, 8);
        $amTo = substr($time, 12, 8);
        $pmFrom = substr($time, 25, 8);
        $pmTo = substr($time, 36, 8);

        $amFrom = ($amFrom != null && $amFrom != '00:00 AM') ? date('H:i', strtotime($amFrom)) : '';
        $amTo = ($amTo != null && ($amTo != '00:00 AM' && $amTo != '00:00 PM')) ? date('H:i', strtotime($amTo)) : '';
        $pmFrom = ($pmFrom != null && $pmFrom != '00:00 PM') ? date('H:i', strtotime($pmFrom)) : '';
        $pmTo = ($pmTo != null && $pmTo != '00:00 PM') ? date('H:i', strtotime($pmTo)) : '';
        
        return [$amFrom, $amTo, $pmFrom, $pmTo];
    }
}
