<?php

namespace App\Http\Controllers\Dashboard\Merchant\Doctor\Schedule;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

//Add Models
use App\Models\DoctorSchedule;

use Redirect;

class UpdateController extends Controller
{
    public function index(Request $request, $id)
    {
    	$params = [
    		'monday'	=> $this->formatRequestTime($request->monday),
    		'tuesday' 	=> $this->formatRequestTime($request->tuesday),
    		'wednesday'	=> $this->formatRequestTime($request->wednesday),
    		'thursday'	=> $this->formatRequestTime($request->thursday),
    		'friday'	=> $this->formatRequestTime($request->friday),
    		'saturday'	=> $this->formatRequestTime($request->saturday),
    		'sunday'	=> $this->formatRequestTime($request->sunday),
    	];

    	$schedule = DoctorSchedule::where('doctor_id', base64_decode($id))->first();

    	if ($schedule->update($params)) {

            $params = [
                'user_id' => auth()->user()->id, 
                'activity' => 'Doctors Schedule Update',
                'reference_id' => $schedule->id,
                'table' => 'doctor_schedules',
                'remarks' => 'Successfully updated doctor schedule.',
            ];

            $this->addLogs($params);

            return Redirect::route('merchants.doctors')
                    ->with(['success' => 'Successfully updated schedule']);
            
    	}

        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Doctors Schedule Update',
            'reference_id' => base64_decode($id),
            'table' => 'doctor_schedules',
            'remarks' => 'Failed to update doctor schedule.',
        ];

        $this->addLogs($params);

        return Redirect::route('merchants.doctors.schedules.edit', $id)
                    ->withErrors($schedule->getErrors())
                    ->withInput();
    }

    public function formatRequestTime($times)
    {
    	$am = [];
        $pm = [];
        foreach ($times as $key => $time) {
            if ($key == 0 || $key == 1) {
               $am[] = ($time != null) ? $this->twelveHourFormat($time) : '00:00 AM';
            } else {
               $pm[] = ($time != null) ? $this->twelveHourFormat($time) : '00:00 PM';
            }
        }

        $implodeTime = '['.implode(" - ", $am).'] - ['.implode(" - ", $pm).']';
        $timeformat = '[00:00 AM - 00:00 AM] - [00:00 PM - 00:00 PM]';

        return $implodeTime == $timeformat ? null : $implodeTime;
    }

    // 12-hour clock format
    public function twelveHourFormat($time)
    {
    	return date('h:i A', strtotime($time));
    }
}
