<?php

namespace App\Http\Controllers\Dashboard\Merchant\Doctor\Review;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

//Add External Classes
use Yajra\Datatables\Datatables;

//Add Models
use App\Models\DoctorReview;

class ViewController extends Controller
{
    public function index()
    {
        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Review View',
            'reference_id' => null,
            'table' => 'doctors',
            'remarks' => 'Review View Success',
        ];

        $this->addLogs($params);

    	return view('dashboard.merchants.doctors.reviews.index');
    }

    public function doctorReviewList()
    {
    	$reviews = DoctorReview::select([
                    'doctor_reviews.rate',
                    'doctor_reviews.comment',
                    'doctor_reviews.created_at',
                    'user_images.path',
                    'users.firstname',
                    'users.middlename',
                    'users.lastname',
                ])
                ->join('doctor_appointments', 'doctor_appointments.id', 'doctor_reviews.appointment_id')
                ->leftJoin('doctors', 'doctors.id', 'doctor_appointments.doctor_id')
                ->leftJoin('users', 'users.id', 'doctor_appointments.user_id')
                ->leftJoin('user_images', 'user_images.auth_by', 'users.id')
                ->where('doctor_appointments.doctor_id', auth()->user()->account->id)
                ->latest()
                ->get();

        return Datatables::of($reviews)
            ->addIndexColumn()
            ->addColumn('name', function($review){
                $name = ucwords($review->firstname.' '.$review->middlename.' '.$review->lastname);
                $photo = (isset($review->path)) ? 
                            '<img src="'.config('app.AWS_BUCKET_URL').$review->path.'" class="rounded-circle mr-2" width="40px" height="40px">' : 
                            '<img src='.asset('admin_dashboard/img/default.png').' class="rounded-circle mr-2" width="40px" height="40px">' ;
                return $photo.' '.$name;
            })
            ->addColumn('rate', function($review){
                $active = ($review->rate >= 5) ? 5 : $review->rate;
                $inactive = 5 - (($review->rate >= 5) ? 5 : $review->rate);
                $activeStar = str_repeat('<i class="mdi mdi-star mdi-18px text-warning"></i>', $active);
                $inactiveStar = str_repeat('<i class="mdi mdi-star mdi-18px"></i>', $inactive);

                return $activeStar.$inactiveStar;
            })
            ->addColumn('comment', function($review){
                return $review->comment;
            })
            ->addColumn('created_at', function($review){
                return $review->created_at->format('M d,Y h:i:s A');
            })
            ->escapeColumns([])->make(true);
    }
}
