<?php

namespace App\Http\Controllers\Dashboard\Merchant\Doctor\Report;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

//Add External Classes
use Yajra\Datatables\Datatables;

//Add Models
use App\Models\DoctorAppointment;
use App\Models\Merchant;

use DB;

class ViewController extends Controller
{
    public function index()
    {
        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Doctor Reports View',
            'reference_id' => null,
            'table' => 'doctor_appointments',
            'remarks' => 'Doctor Reports View Success',
        ];

        $this->addLogs($params);

    	return view('dashboard.merchants.doctors.reports.index');
    }

    public function doctorReportList(Request $request)
    {
    	$appointments = $this->getDoctorCustomDateRange($request);

        return Datatables::of($appointments)
            ->addIndexColumn()
            ->addColumn('appointment_id', function($product){
                return $product->appointment_id;
            })
            ->addColumn('name', function($appointment){
                $name = ucwords($appointment->firstname.' '.$appointment->middlename.' '.$appointment->lastname);
                $photo = (isset($appointment->path)) ? 
                            '<img src="'.config('app.AWS_BUCKET_URL').$appointment->path.'" class="rounded-circle mr-2" width="40px" height="40px">' : 
                            '<img src='.asset('admin_dashboard/img/default.png').' class="rounded-circle mr-2" width="40px" height="40px">' ;
                return $photo.' '.$name;
            })
            ->addColumn('reference_id', function($appointment){
                return $appointment->reference_id;
            })
            ->addColumn('date_time', function($appointment){
                return $appointment->date_time;
            })
            ->addColumn('payment_method', function($appointment){
            	return ucwords($appointment->payment_method);
            })
            ->addColumn('establishment', function($appointment){
                return $appointment->establishment;
            })
            ->addColumn('status', function($appointment){
            	if ($appointment->status == 'pending') {
                    $status = '<i class="mdi mdi-checkbox-blank-circle text-warning"></i> Pending' ;
                } elseif ($appointment->status == 'approved') {
                    $status = '<i class="mdi mdi-checkbox-blank-circle text-info"></i> Approved';
                } elseif ($appointment->status == 'completed'){
                    $status = '<i class="mdi mdi-checkbox-blank-circle text-success"></i> Completed';
                } else {
                    $status = '<i class="mdi mdi-checkbox-blank-circle text-danger"></i> '.ucwords($appointment->status);
                }
                return $status;
            })
            ->addColumn('action', function($appointment){
                $button = '<a href='.route('doctors.appointments.view', base64_encode($appointment->id)).' id="view">
                                <button class="btn btn-sm btn-info mr-1"> 
                                    <i class="mdi mdi-eye"></i> View
                                </button>
                            </a>';
                $action = '<div style="display:flex">
                                '.$button.'
                           </div>';
                return $action;
            })
            ->escapeColumns([])->make(true);
    }

    // get custom doctors type reports
    public function getDoctorCustomDateRange($request)
    {
        if (isset($request->status) && $request->status != 'all') {
            
            if ($request->status != 'ratings') {

                $appointments = DoctorAppointment::select([
                        'users.firstname',
                        'users.middlename',
                        'users.lastname',
                        'users.email',
                        'user_images.path',
                        'doctor_appointments.id',
                        'doctor_appointments.appointment_id',
                        'doctor_appointments.reference_id',
                        'doctor_appointments.payment_method',
                        'doctor_appointments.date_time',
                        'doctor_appointments.status',
                        'doctor_appointments.created_at',
                        'establishments.name as establishment',
                    ])
                    ->leftJoin('doctors', 'doctors.id', 'doctor_appointments.doctor_id')
                    ->leftJoin('users', 'users.id', 'doctor_appointments.user_id')
                    ->leftJoin('user_images', 'user_images.auth_by', 'users.id')
                    ->leftJoin('merchant_agreements', 'merchant_agreements.merchant_id', 'doctors.merchant_id')
                    ->leftJoin('establishments', 'establishments.id', 'merchant_agreements.establishment_id')
                    ->where('doctors.id', auth()->user()->account->id)
                    ->where('doctor_appointments.status', $request->status)
                    ->latest()
                    ->get();

            } else {

                $appointments = DoctorAppointment::select([
                        'users.firstname',
                        'users.middlename',
                        'users.lastname',
                        'users.email',
                        'user_images.path',
                        'doctor_appointments.id',
                        'doctor_appointments.appointment_id',
                        'doctor_appointments.reference_id',
                        'doctor_appointments.payment_method',
                        'doctor_appointments.date_time',
                        'doctor_appointments.status',
                        'doctor_appointments.created_at',
                        'establishments.name as establishment',
                        DB::raw('count(case when doctor_appointments.status = "pending" then doctor_appointments.status else null end) as pending'),
                        DB::raw('count(case when doctor_appointments.status = "approved" then doctor_appointments.status else null end) as approved'),
                        DB::raw('count(case when doctor_appointments.status = "completed" then doctor_appointments.status else null end) as completed'),
                        DB::raw('count(case when doctor_appointments.status = "cancelled" then doctor_appointments.status else null end) as cancelled'),
                        DB::raw('count(case when doctor_appointments.status = "declined" then doctor_appointments.status else null end) as declined'),
                    ])
                    ->leftJoin('doctors', 'doctors.id', 'doctor_appointments.doctor_id')
                    ->leftJoin('users', 'users.id', 'doctor_appointments.user_id')
                    ->leftJoin('user_images', 'user_images.auth_by', 'users.id')
                    ->leftJoin('merchant_agreements', 'merchant_agreements.merchant_id', 'doctors.merchant_id')
                    ->leftJoin('establishments', 'establishments.id', 'merchant_agreements.establishment_id')
                    ->where('doctors.id', auth()->user()->account->id)
                    ->groupBy('doctor_appointments.user_id')
                    ->latest()
                    ->get();
            }

        } else {

            $appointments = DoctorAppointment::select([
                    'users.firstname',
                    'users.middlename',
                    'users.lastname',
                    'users.email',
                    'user_images.path',
                    'doctor_appointments.id',
                    'doctor_appointments.appointment_id',
                    'doctor_appointments.reference_id',
                    'doctor_appointments.payment_method',
                    'doctor_appointments.date_time',
                    'doctor_appointments.status',
                    'doctor_appointments.created_at',
                    'establishments.name as establishment',
                ])
                ->leftJoin('doctors', 'doctors.id', 'doctor_appointments.doctor_id')
                ->leftJoin('users', 'users.id', 'doctor_appointments.user_id')
                ->leftJoin('user_images', 'user_images.auth_by', 'users.id')
                ->leftJoin('merchant_agreements', 'merchant_agreements.merchant_id', 'doctors.merchant_id')
                ->leftJoin('establishments', 'establishments.id', 'merchant_agreements.establishment_id')
                ->where('doctors.id', auth()->user()->account->id)
                ->latest()
                ->get();
        }

        return $appointments;
    }
}
