<?php

namespace App\Http\Controllers\Dashboard\Merchant\Doctor\Patient;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

//Add External Classes
use Yajra\Datatables\Datatables;

//Add Models
use App\Models\DoctorAppointment;

class ViewController extends Controller
{
    public function index()
    {
        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Doctor Patient View',
            'reference_id' => null,
            'table' => 'doctor_appointments',
            'remarks' => 'Doctor Patient View Success',
        ];

        $this->addLogs($params);

    	return view('dashboard.merchants.doctors.patients.index');
    }

    public function patientList()
    {
    	$patients = DoctorAppointment::select([
                    'user_images.path',
                    'users.firstname',
                    'users.middlename',
                    'users.lastname',
                    'users.email',
                    'members.id',
                    'members.mobile_number',
                    'doctor_appointments.reference_id',
                    'doctor_appointments.status',
                    'doctor_appointments.created_at',
                ])
            	->leftJoin('doctors', 'doctors.id', 'doctor_appointments.doctor_id')
                ->leftJoin('users', 'users.id', 'doctor_appointments.user_id')
                ->leftJoin('members', 'members.user_id', 'users.id')
                ->leftJoin('user_images', 'user_images.auth_by', 'users.id')
                ->where('doctors.id', auth()->user()->account->id)
                ->groupBy('user_images.path','users.firstname','users.middlename','users.lastname','users.email','members.id','members.mobile_number','doctor_appointments.reference_id','doctor_appointments.status','doctor_appointments.created_at')
            	->latest()
                ->get();

        return Datatables::of($patients)
            ->addIndexColumn()
            ->addColumn('name', function($patient){
                $name = ucwords($patient->firstname.' '.$patient->middlename.' '.$patient->lastname);
                $photo = (isset($patient->path)) ? 
                            '<img src="'.config('app.AWS_BUCKET_URL').$patient->path.'" class="rounded-circle mr-2" width="40px" height="40px">' : 
                            '<img src='.asset('admin_dashboard/img/default.png').' class="rounded-circle mr-2" width="40px" height="40px">' ;
                return $photo.' '.$name;
            })
            ->addColumn('email', function($patient){
                return $patient->email;
            })
            ->addColumn('reference_id', function($patient){
                return $patient->reference_id;
            })
            ->addColumn('mobile_number', function($patient){
                return $patient->mobile_number;
            })
            ->addColumn('created_at', function($patient){
                return $patient->created_at->format('M d,Y h:i:s A');
            })
            ->addColumn('action', function($patient){
                $button = '<a href='.route('doctors.appointments.view', base64_encode($patient->id)).' id="view">
                                <button class="btn btn-sm btn-info mr-1"> 
                                    <i class="mdi mdi-eye"></i> View
                                </button>
                            </a>';
                $action = '<div style="display:flex">
                                '.$button.'
                           </div>';
                return $action;
            })
            ->escapeColumns([])->make(true);
    }
}
