<?php

namespace App\Http\Controllers\Dashboard\Merchant\Doctor;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

//Add Models
use App\Models\DoctorPaymentMethod;
use App\Models\DoctorSpeciality;
use App\Models\Doctor;
use App\Models\User;

use Redirect;
use Hash;
use DB;

class CreateController extends Controller
{
    public function index(Request $request)
    {
    	DB::beginTransaction();

    	$request->merge([
    		'password' => Hash::make('pplus2020'),
    		'usertype' => 'doctor',
    		'minimum_consultation_fee' => str_replace(',', '', $request->minimum_consultation_fee),
    		'maximum_consultation_fee' => str_replace(',', '', $request->maximum_consultation_fee),
    	]);

    	$userParams = $request->only(['firstname','middlename','lastname','username','email','password','usertype']);
    	$user = new User($userParams);

    	if ($user->save()) {

    		$params = $request->only(['prefix','contact_number','minimum_consultation_fee','maximum_consultation_fee']);
    		$params['user_id'] = $user->id;
			$params['merchant_id'] = auth()->user()->account->merchant_id;
			$params['professional_id'] = $this->generateDoctorId();
			$doctor = new Doctor($params);

			if (!$doctor->save()) {
				// Rollback and then redirect & back to form with errors
				DB::rollback();

				$params = [
                    'user_id' => auth()->user()->id, 
                	'activity' => 'Doctors Registration',
                    'reference_id' => null,
                	'table' => 'users and doctors',
                    'remarks' => 'Error registering doctor.',
                ];

                $this->addLogs($params);

				return Redirect::route('merchants.doctors.add')
			        ->withErrors($doctor->getErrors())
			        ->withInput();
			}
			
			$this->storeDoctorSpecialities($request->doctor_specialities, $doctor->id);
			$this->storePaymentMethods($request->doctor_payment_methods, $doctor->id);

            //SAVE IMAGE TO S3
            $this->storeDoctorImage($request, $doctor->id);
            
            //ASSIGN ROLE
            $this->assignRole($user);

			DB::commit();

			$params = [
                'user_id' => auth()->user()->id, 
                'activity' => 'Doctors Registration',
                'reference_id' => $user->id,
                'table' => 'users and doctors',
                'remarks' => 'Successfully registered doctor.',
            ];

            $this->addLogs($params);

			return Redirect::route('merchants.doctors')
						->with(['success' => 'Successfully added doctor']);
    	}

    	return Redirect::route('merchants.doctors.add')
				        ->withErrors($user->getErrors())
				        ->withInput();
    }

    public function storeDoctorSpecialities($doctor_specialities, $doctorId)
    {
    	foreach ($doctor_specialities as $speciality) {
				
			$params = [
                'doctor_id' 	=> $doctorId,
                'speciality_id' => $speciality,
            ];

			DoctorSpeciality::create($params);
		}
    }

    public function storePaymentMethods($doctor_payment_methods, $doctorId)
    {
    	foreach ($doctor_payment_methods as $payment) {
			
			$params = [
                'doctor_id' => $doctorId,
                'name' 		=> $payment,
            ];

			DoctorPaymentMethod::create($params);
		}
    }

    // Generate Doctor ID
    public function generateDoctorId()
    {	
    	$code = $this->generateNumericCode(3);
    	$random = $this->generateNumericCode(10);
        $doctor = Doctor::where('professional_id','LIKE','%PROF:'.$code.':'.$random.'%')->first();

        if (isset($doctor)) {
            $code = $this->generateAlphaNumeric(3);
    		$random = $this->generateNumericCode(10);
        }    

        return 'PROF:'.$code.':'.$random;
    }

    // Generate Numberic Code
    public function generateNumericCode($limit)
    {
        $code = '';
        for($i = 0; $i < $limit; $i++) { 
            $code .= mt_rand(0, 9); 
        }

        return $code;
    }
}
