<?php

namespace App\Http\Controllers\Dashboard\Merchant;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

//Add Models
use App\Models\MerchantAgreement;
use App\Models\PaymentMethod;
use App\Models\Merchant;

use Redirect;
use DB;

class CreateController extends Controller
{
    public function index(Request $request)
    {   
        DB::beginTransaction();

        $params = $request->all();
        $params['referral_code'] = $this->generateReferralCode();
    	$merchant = new Merchant($params);

    	if ($merchant->save()) {

            if (isset($request->is_mobile)) {
                
                $params['merchant_id'] = $merchant->id;
                $merchantAgreement = new MerchantAgreement($params);
                if (!$merchantAgreement->save()) {
                    // Rollback and then redirect & back to form with errors
                    DB::rollback();

                    $params = [
                        'user_id' => auth()->user()->id, 
                        'activity' => 'Register Merchant',
                        'reference_id' => null,
                        'table' => 'merchants and merchant_agreements',
                        'remarks' => 'Failed to add new merchant',
                    ];

                    $this->addLogs($params);

                    return Redirect::route('merchants.add')
                        ->withErrors($merchantAgreement->getErrors())
                        ->withInput();
                }
                
                foreach ($request->payment_method as $method) {
                    $params = [
                        'merchant_agreement_id' => $merchantAgreement->id,
                        'name' => $method,
                    ];

                    $paymentMethod = new PaymentMethod($params);

                    if (!$paymentMethod->save()) {
                        // Rollback and then redirect & back to form with errors
                        DB::rollback();

                        $params = [
                            'user_id' => auth()->user()->id, 
                            'activity' => 'Register Merchant',
                            'reference_id' => null,
                            'table' => 'merchants, merchant_agreements and payment_methods',
                            'remarks' => 'Failed to add new merchant',
                        ];

                        $this->addLogs($params);

                        return Redirect::route('merchants.add')
                            ->withErrors($paymentMethod->getErrors())
                            ->withInput();
                    }
                }
            }

            //SAVE IMAGE TO S3
            $this->storeMerchantImage($request, $merchant->id);
            
            DB::commit();

    		$params = [
                'user_id' => auth()->user()->id, 
                'activity' => 'Register Merchant',
                'reference_id' => $merchant->id,
                'table' => 'merchants, merchant_agreements and payment_methods',
                'remarks' => 'Successfully added new merchant',
            ];

            $this->addLogs($params);
            
			return Redirect::route('merchants')->with(['success' => 'Successfully added new merchant']);
    	}

        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Register Merchant',
            'reference_id' => null,
            'table' => 'merchants',
            'remarks' => 'Failed to add new merchant',
        ];

        $this->addLogs($params);

    	return Redirect::route('merchants.add')
	        ->withErrors($merchant->getErrors())
	        ->withInput();
    }

    // Generate Referral Code
    public function generateReferralCode()
    {
        $code = $this->generateAlphaNumeric(7);
        $merchant = Merchant::where('referral_code', $code)->first();

        if (isset($merchant)) {
            $code = $this->generateAlphaNumeric(7);
        }    

        return $code;
    }

    // Generate Alpha Numberic
    public function generateAlphaNumeric($limit)
    {
        $code = substr(base_convert(sha1(uniqid(mt_rand())), 16, 36), 0, $limit);

        return strtoupper($code);
    }
}
