<?php

namespace App\Http\Controllers\Dashboard\Merchant\Cashier;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

//Add Models
use App\Models\MerchantCashier;
use App\Models\User;

use Redirect;
use Hash;
use DB;

class UpdateController extends Controller
{
    public function index(Request $request, $id)
    {
    	DB::beginTransaction();

    	$userParams = $request->only(['firstname','middlename','lastname','email']);
    	$user = User::find(base64_decode($id));

    	if ($user->update($userParams)) {

    		$params = $request->only(['image','employee_number','department']);
			$cashier = MerchantCashier::where('user_id', $user->id)->first();

			if (!$cashier->update($params)) {
				// Rollback and then redirect & back to form with errors
				DB::rollback();

				$params = [
                    'user_id' => auth()->user()->id, 
                	'activity' => 'Merchant Cashier Edit',
                    'reference_id' => null,
                	'table' => 'users and merchant_cashiers',
                    'remarks' => 'Error updating merchant cashier.',
                ];

                $this->addLogs($params);

				return Redirect::route('merchants.cashiers.edit', $id)
			        ->withErrors($cashier->getErrors())
			        ->withInput();
			}
			
            //SAVE IMAGE TO S3
            $this->storeUserImage($request, $user->id);
            
            //ASSIGN ROLE
            $this->assignRole($user);

			DB::commit();

			$params = [
                'user_id' => auth()->user()->id, 
                'activity' => 'Merchant Cashier Edit',
                'reference_id' => $user->id,
                'table' => 'users and merchant_cashiers',
                'remarks' => 'Successfully updated merchant cashier.',
            ];

            $this->addLogs($params);

			return Redirect::route('merchants.cashiers')
						->with(['success' => 'Successfully updated merchant cashier']);
    	}

    	return Redirect::route('merchants.cashiers.edit', $id)
				        ->withErrors($user->getErrors())
				        ->withInput();
    }

    public function status($id)
    {
        $user = User::find(base64_decode($id));

        if ($user->status == 1) {
            
            $user->update(['status' => 0]);

            $params = [
                'user_id' => auth()->user()->id, 
                'activity' => 'Merchant Cashier Deactivation',
                'reference_id' => base64_decode($id),
                'table' => 'users',
                'remarks' => 'Success deactivating merchant cashier.',
            ];
            
            $this->addLogs($params);

            return response()->json(['message' => 'Merchant Cashier deactivated successfully']);
        }

        $user->update(['status' => 1]);

        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Merchant Cashier Activation',
            'reference_id' => base64_decode($id),
            'table' => 'users',
            'remarks' => 'Success activating merchant cashier.',
        ];

        $this->addLogs($params);

        return response()->json(['message' => 'Merchant Cashier activated successfully']);
    }

    public function resetPassword($id)
    {
        $user = User::find(base64_decode($id));
        $user->update(['password' => Hash::make('pplus2020')]);

        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Merchant Cashier Reset Password',
            'reference_id' => base64_decode($id),
            'table' => 'users',
            'remarks' => 'Success merchant cashier reset password.',
        ];

        $this->addLogs($params);

        // Should send an email/text that his password is reset!
        // code...

        return response()->json(['message' => 'Merchant Cashier Password reset successfully']);
    }
}
