<?php

namespace App\Http\Controllers\Dashboard\Merchant\Cashier;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

//Add Models
use App\Models\MerchantCashier;
use App\Models\User;

use Redirect;
use Hash;
use DB;

class CreateController extends Controller
{
    public function index(Request $request)
    {
    	DB::beginTransaction();

    	$request->merge([
    		'password' => Hash::make('pplus2020'),
    		'usertype' => 'merchant_cashier',
    	]);
    	$userParams = $request->only(['firstname','middlename','lastname','username','email','password','usertype']);
    	$user = new User($userParams);

    	if ($user->save()) {

    		$params = $request->only(['image','employee_number','department']);
    		$params['user_id'] = $user->id;
			$params['merchant_id'] = auth()->user()->account->merchant_id;
			$params['cashier_id'] = $this->generateCashierId($user->usertype);
			$cashier = new MerchantCashier($params);

			if (!$cashier->save()) {
				// Rollback and then redirect & back to form with errors
				DB::rollback();

				$params = [
                    'user_id' => auth()->user()->id, 
                	'activity' => 'Merchant Cashier Registration',
                    'reference_id' => null,
                	'table' => 'users and merchant_cashiers',
                    'remarks' => 'Error registering merchant cashier.',
                ];

                $this->addLogs($params);

				return Redirect::route('merchants.cashiers.add')
			        ->withErrors($cashier->getErrors())
			        ->withInput();
			}
			
            //SAVE IMAGE TO S3
            $this->storeUserImage($request, $user->id);
            
            //ASSIGN ROLE
            $this->assignRole($user);

			DB::commit();

			$params = [
                'user_id' => auth()->user()->id, 
                'activity' => 'Merchant Cashier Registration',
                'reference_id' => $user->id,
                'table' => 'users and merchant_cashiers',
                'remarks' => 'Successfully registered merchant cashier.',
            ];

            $this->addLogs($params);

			return Redirect::route('merchants.cashiers')
						->with(['success' => 'Successfully added merchant cashier']);
    	}

    	return Redirect::route('merchants.cashiers.add')
				        ->withErrors($user->getErrors())
				        ->withInput();
    }
}
