<?php

namespace App\Http\Controllers\Dashboard\Member;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

//Add External Classes
use Illuminate\Support\Facades\Storage;
use Yajra\Datatables\Datatables;

//Add Models
use App\Models\AdminPointSetting;
use App\Models\MemberType;
use App\Models\AreaCode;
use App\Models\Member;
use App\Models\User;
use App\Models\Referral;
use App\Models\TransactionOrder;
use App\Models\PointTransaction;
use App\Models\MemberPointTransactions;
use App\Models\BayanihanPointSetting;
//Mails
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Str;
use App\Mail\VerifyMember;
use DB;
use Redirect;

class ViewController extends Controller
{
    public function index()
    {
        $params = [
            "user_id" => auth()->user()->id,
            "activity" => "Members View",
            "reference_id" => null,
            "table" => "members",
            "remarks" => "Members View Success",
        ];

        //$this->addLogs($params);

        return view("dashboard.members.index", [
            "area_codes" => $this->getActiveAreaCodes(),
            "member_types" => $this->getActiveMemberTypes(),
        ]);
    }

    public function add()
    {
        $params = [
            "user_id" => auth()->user()->id,
            "activity" => "Member Add",
            "reference_id" => null,
            "table" => "members and users",
            "remarks" => "Successfully viewed Add member page.",
        ];

        $this->addLogs($params);

        return view("dashboard.members.add", [
            "member_types" => $this->getActiveMemberTypes(),
        ]);
    }

    public function transactions($request)
    {
        /* $transactions = TransactionOrder::where('user_id', '=', base64_decode($request))->limit(1000)->get();
        return view('dashboard.members.transactions',[
            'transactions'=> $transactions
        ]);
        */
        $user = User::where("id", "=", base64_decode($request))->first();
        $member = Member::where(
            "user_id",
            "=",
            base64_decode($request)
        )->first();

        
        $referrals = 0;
        $referral_counter = 0;
        $referrals = Referral::where("user_upline_id", base64_decode($request))->get();
        foreach ($referrals as $key) {
           
            $check_membertype = Member::where("user_id", $key->user_id)
                                        ->where(function ($query) {
                                        $query->where('registration_status', '=', 'Regular')
                                              ->orWhere('registration_status', '=', 'unverified');
                                    })->count();

                if($check_membertype > 0){

                    $referral_counter++;

                }
            
        }
   
        

        $bayanihan_points = DB::table("bayanihan_point_settings")
            ->select("points")
            ->where("status", 1)
            ->first();

        $pending =  $bayanihan_points->points * $referral_counter;

        return view("dashboard.members.transactions", [
            "user_id" => $request,
            "user_data" => $user,
            "member_data" => $member,
            "pending_points" => round($pending, 2, PHP_ROUND_HALF_UP),
        ]);
    }

    public function transactionList(Request $request)
    {
        if (isset($request->date)) {
            $date = explode("-", $request->date);
            $startDate = date("Y-m-d", strtotime($date[0]));
            $endDate = date("Y-m-d", strtotime($date[1]));

            $transactions = MemberPointTransactions::where("upline_user_id","=",base64_decode($request->user_id))
                ->where('description','New Referral')
                ->whereBetween("created_at", [$startDate, $endDate])
                ->orWhere("user_id","=",base64_decode($request->user_id))
                ->where('description','Membership Upgrade')
                ->whereBetween("created_at", [$startDate, $endDate])
                ->orWhere("user_id","=",base64_decode($request->user_id))
                ->where('description','Loyalty Points')
                ->whereBetween("created_at", [$startDate, $endDate])
                ->orWhere("user_id","=",base64_decode($request->user_id))
                ->where('description','System Maintenance')
                ->whereBetween("created_at", [$startDate, $endDate])
                ->orWhere("user_id","=",base64_decode($request->user_id))
                ->where('description','Advocacy')
                ->whereBetween("created_at", [$startDate, $endDate])
                ->orWhere("user_id","=",base64_decode($request->user_id))
                ->where('description','Biz Center Ops')
                ->whereBetween("created_at", [$startDate, $endDate])
                ->orWhere("user_id","=",base64_decode($request->user_id))
                ->where('description','HQ Operations')
                ->whereBetween("created_at", [$startDate, $endDate])
                ->orWhere("user_id","=",base64_decode($request->user_id))
                ->where('description','Loyalty Point Bayanihan')
                ->orWhere("user_id","=",base64_decode($request->user_id))
                ->where('description','Loyalty Point Commission')
                ->whereBetween("created_at", [$startDate, $endDate])
                ->limit(1000)
                ->get();


            return Datatables::of($transactions)
                ->addIndexColumn()
                ->addColumn("reference_id", function ($transactions) {
                    return $transactions->reference_id;
                })
                ->addColumn("date", function ($transactions) {
                    $time = strtotime($transactions->created_at);
                    $dateInLocal = date("Y-m-d h:i A", $time);
                    return   $dateInLocal;
                })
                ->addColumn("address", function ($transactions) {
                    return $transactions->description;
                })
                ->addColumn("delivery_amount", function ($transactions) {
                    return $transactions->points;
                })
                ->addColumn("member", function ($transactions) {

                    $member_data = Member::where("user_id", $transactions->user_id)->first();
                    $member_data_upline = Member::where("user_id", $transactions->upline_user_id)->first();

                    if($transactions->upline_user_id == 0 || $transactions->description == "Membership Upgrade")
                    {
                        return "";
                    }
                    else if($transactions->description == "New Referral")
                    {
                        return $member_data->member_id;
                    }
                    else if($transactions->description == "Advocacy" || $transactions->description == "System Maintenance" || $transactions->description == "Central Operations" || $transactions->description == "Biz Center Ops" || $transactions->description == "HQ Operations" || $transactions->description == "Loyalty Point Commission")
                    {
                        return $member_data->upline_user_id;
                    }
                    else
                    {
                        return $member_data->upline_user_id;
                    }
                })
                ->addColumn("status", function ($transactions) {
                    return "Success";
                })
                ->escapeColumns([])
                ->make(true);
        } else {

            $transactions = MemberPointTransactions::where("upline_user_id","=",base64_decode($request->user_id))
                ->where('description','New Referral')
                ->orWhere("user_id","=",base64_decode($request->user_id))
                ->where('description','Membership Upgrade')
                ->orWhere("user_id","=",base64_decode($request->user_id))
                ->where('description','Loyalty Points')
                ->orWhere("user_id","=",base64_decode($request->user_id))
                ->where('description','System Maintenance')
                ->orWhere("user_id","=",base64_decode($request->user_id))
                ->where('description','Advocacy')
                ->orWhere("user_id","=",base64_decode($request->user_id))
                ->where('description','Biz Center Ops')
                ->orWhere("user_id","=",base64_decode($request->user_id))
                ->where('description','HQ Operations')
                ->orWhere("user_id","=",base64_decode($request->user_id))
                ->where('description','Loyalty Point Bayanihan')
                ->orWhere("user_id","=",base64_decode($request->user_id))
                ->where('description','Loyalty Point Commission')
                ->limit(1000)
                ->get();

            return Datatables::of($transactions)
                ->addIndexColumn()
                ->addColumn("reference_id", function ($transactions) {
                    return $transactions->reference_id;
                })
                ->addColumn("date", function ($transactions) {
                    $time = strtotime($transactions->created_at);
                    $dateInLocal = date("Y-m-d h:i A", $time);
                    return   $dateInLocal;
                })
                ->addColumn("address", function ($transactions) {
                    return $transactions->description;
                })
                ->addColumn("delivery_amount", function ($transactions) {
                    return $transactions->points;
                })
                ->addColumn("member", function ($transactions) {

                    $member_data = Member::where("user_id", $transactions->user_id)->first();
                    $member_data_upline = Member::where("user_id", $transactions->upline_user_id)->first();

                    if($transactions->upline_user_id == 0 || $transactions->description == "Membership Upgrade")
                    {
                        return "";
                    }
                    else if($transactions->description == "New Referral")
                    {
                       return $member_data->member_id;
                    }
                    else if($transactions->description == "Advocacy" || $transactions->description == "System Maintenance" || $transactions->description == "Central Operations" || $transactions->description == "Biz Center Ops" || $transactions->description == "HQ Operations" || $transactions->description == "Loyalty Point Commission")
                    {
                        return $member_data_upline->member_id;
                    }
                    else
                    {
                        return $member_data_upline->member_id;
                    }
                })
                ->addColumn("status", function ($transactions) {
                    return "Success";
                })
                ->escapeColumns([])
                ->make(true);
        }
    }
    public function memberList(Request $request)
    {
        $members = $this->customFilterMember($request);

        return Datatables::of($members)
            ->addIndexColumn()
            ->addColumn("name", function ($member) {
                $name = $member->user->getFullName();
                //$name = "Member Name";
                //$name = optional($member->user)->getFullname();
                $photo = isset($member->user_image[0]->path)
                    ? '<img src="' .
                        config("app.AWS_BUCKET_URL") .
                        $member->user_image[0]->path .
                        '" class="rounded-circle mr-2" width="40px" height="40px">'
                    : '<img src="admin_dashboard/img/default.png" class="rounded-circle mr-2" width="40px" height="40px">';
                return $photo . " " . $name;
            })
            ->addColumn("card_number", function ($member) {
                return $this->formatCardNumber($member->card_number);
            })
            ->addColumn("referral_code", function ($member) {
                return $member->referral_code;
            })
            ->addColumn("member_type", function ($member) {
                return $member->member_type->name;
            })
            ->addColumn("status", function ($member) {
                $status =
                    $member->registration_status == "Premium" ||
                    $member->registration_status == "verified"
                        ? '<i class="mdi mdi-checkbox-blank-circle text-success"></i> Premium'
                        : '<i class="mdi mdi-checkbox-blank-circle text-danger"></i> Regular';
                return $status;
            })
            ->addColumn("action", function ($member) {
                $button =
                    "<a href=" .
                    route("members.view", base64_encode($member->user_id)) .
                    ' class="dropdown-item" id="view">
                                <i class="ti-eye"></i> View
                            </a>';
                if (
                    auth()
                        ->user()
                        ->isSuperAdmin() ||
                    auth()
                        ->user()
                        ->isAdmin()
                ) {
                    $button .=
                        "<a href=" .
                        route("members.edit", base64_encode($member->user_id)) .
                        ' class="dropdown-item" id="edit">
                                    <i class="ti-pencil"></i> Edit
                                </a>';
                    $button .=
                        $member->registration_status != "Premium"
                            ? '<a href="javascript:;" data-id=' .
                                base64_encode($member->user_id) .
                                ' onclick="verifyModal(this)" class="dropdown-item" id="edit">
                                    <i class="mdi mdi-check-circle-outline"></i> Verify
                                </a>'
                            : "";
                    $button .= '<div class="dropdown-divider"></div>';
                    $button .=
                        "<a href=" .
                        route("bayanihan", base64_encode($member->user_id)) .
                        ' target="_blank" class="dropdown-item">
                                    <i class="ti-bar-chart"></i> Bayanihan
                                </a>';
                    $button .=
                        "<a href=" .
                        route(
                            "bayanihan.referrals",
                            base64_encode($member->referral_code)
                        ) .
                        ' class="dropdown-item" id="referral-link">
                                    <i class="ti-user"></i> Referral Link
                                </a>';
                    $button .=
                        "<a href=" .
                        route(
                            "members.transactions",
                            base64_encode($member->user_id)
                        ) .
                        ' target="_blank" class="dropdown-item" id="transact">
                                    <i class="mdi mdi-clipboard-check"></i> Transactions
                                </a>';
                } elseif (
                    auth()
                        ->user()
                        ->isAdminCashier()
                ) {
                    $button .=
                        $member->registration_status != "Premium"
                            ? '<a href="javascript:;" data-id=' .
                                base64_encode($member->user_id) .
                                ' onclick="verifyModal(this)" class="dropdown-item" id="edit">
                                    <i class="mdi mdi-check-circle-outline"></i> Verify
                                </a>'
                            : "";
                }
                $action =
                    '<div class="btn-group">
                                <button type="button" class="btn btn-sm btn-outline-info dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    <i class="ti-view-list-alt"></i> Options
                                </button>
                                <div class="dropdown-menu dropdown-menu-right">
                                    ' .
                    $button .
                    '
                                </div>
                            </div>';
                return $action;
            })
            ->escapeColumns([])
            ->make(true);
    }

    // Custom Filter Member
    public function customFilterMember($request)
    {
        $category = "";
        if ($request->category == "Regular") {
            $category = "unverified";
        }
        if ($request->cateory == "Premium") {
            $category = "verified";
        }

        if (
            $request->type != null &&
            $request->type != "All" &&
            $request->filter != null
        ) {
            $members = Member::with("user", "member_type", "user_image")
                ->whereHas("user", function ($query) use ($request) {
                    $query
                        ->where(
                            "firstname",
                            "LIKE",
                            "%" . $request->filter . "%"
                        )
                        ->orWhere(
                            "lastname",
                            "LIKE",
                            "%" . $request->filter . "%"
                        );
                })
                ->orwhere(function ($query) use ($request) {
                    $query
                        ->orWhere(
                            "member_id",
                            "LIKE",
                            "%" . $request->filter . "%"
                        )
                        ->orWhere(
                            "card_number",
                            "LIKE",
                            "%" . $request->filter . "%"
                        )
                        ->orWhere(
                            "referral_code",
                            "LIKE",
                            "%" . $request->filter . "%"
                        );
                })
                ->whereHas("member_type", function ($query) use ($request) {
                    $query->where("name", $request->type);
                })
                ->limit(1000)
                ->get();
        } elseif (
            $request->type != null &&
            $request->type != "All" &&
            ($request->category != null && $request->category != "All")
        ) {
            $members = Member::with("user", "member_type", "user_image")
                ->where("registration_status", $request->category)
                ->orwhere("registration_status", $category)
                ->whereHas("member_type", function ($query) use ($request) {
                    $query->where("name", $request->type);
                })
                ->limit(1000)
                ->get();
        } elseif ($request->type != null && $request->type != "All") {
            $members = Member::with("user", "member_type", "user_image")
                ->whereHas("member_type", function ($query) use ($request) {
                    $query->where("name", $request->type);
                })
                ->limit(1000)
                ->get();
        } else {
            if ($request->filter != null) {
                $members = Member::with("user", "member_type", "user_image")
                    ->whereHas("user", function ($query) use ($request) {
                        $query
                            ->where(
                                "firstname",
                                "LIKE",
                                "%" . $request->filter . "%"
                            )
                            ->orWhere(
                                "lastname",
                                "LIKE",
                                "%" . $request->filter . "%"
                            );
                    })
                    ->orwhere(function ($query) use ($request) {
                        $query
                            ->orWhere(
                                "member_id",
                                "LIKE",
                                "%" . $request->filter . "%"
                            )
                            ->orWhere(
                                "card_number",
                                "LIKE",
                                "%" . $request->filter . "%"
                            )
                            ->orWhere(
                                "referral_code",
                                "LIKE",
                                "%" . $request->filter . "%"
                            );
                    })
                    ->limit(1000)
                    ->get();
            } elseif (
                $request->category != null &&
                $request->category != "All"
            ) {
                $members = Member::with("user", "member_type", "user_image")
                    ->where("registration_status", $request->category)
                    ->orwhere("registration_status", $category)
                    ->limit(1000)
                    ->get();
            } else {
                $members = Member::with("user", "member_type", "user_image")
                    ->latest()
                    ->limit(1000)
                    ->get();
            }
        }
        return $members;
    }

    public function memberQualifiedList(Request $request)
    {
        $members = $this->customFilterMemberQualified($request);

        return Datatables::of($members)
            ->addIndexColumn()
            ->addColumn("name", function ($member) {
                $name = $member->user->getFullName();
                $photo = isset($member->user_image[0]->path)
                    ? '<img src="' .
                        config("app.AWS_BUCKET_URL") .
                        $member->user_image[0]->path .
                        '" class="rounded-circle mr-2" width="40px" height="40px">'
                    : '<img src="admin_dashboard/img/default.png" class="rounded-circle mr-2" width="40px" height="40px">';
                return $photo . " " . $name;
            })
            ->addColumn("email", function ($member) {
                return $member->user->email;
            })
            ->addColumn("current_points", function ($member) {
                return $member->current_points;
            })
            ->addColumn("member_type", function ($member) {
                return $member->member_type->name;
            })
            ->addColumn("status", function ($member) {
                $status =
                    $member->registration_status == "Premium" ||
                    $member->registration_status == "verified"
                        ? '<i class="mdi mdi-checkbox-blank-circle text-success"></i> Premium'
                        : '<i class="mdi mdi-checkbox-blank-circle text-danger"></i> Regular';
                return $status;
            })
            ->addColumn("action", function ($member) {
                $button =
                    "<a href=" .
                    route("members.view", base64_encode($member->user_id)) .
                    ' class="dropdown-item" id="view">
                                <i class="ti-eye"></i> View
                            </a>';
                if (
                    auth()
                        ->user()
                        ->isSuperAdmin() ||
                    auth()
                        ->user()
                        ->isAdmin()
                ) {
                    $button .=
                        $member->member_type->name != "Premium"
                            ? "<a href=" .
                                route(
                                    "members.upgrade",
                                    base64_encode($member->user_id)
                                ) .
                                ' class="dropdown-item" id="edit">
                                <i class="ti-arrow-circle-up"></i> Upgrade
                            </a>'
                            : "";
                }
                $action =
                    '<div class="btn-group">
                                <button type="button" class="btn btn-sm btn-outline-info dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    <i class="ti-view-list-alt"></i> Options
                                </button>
                                <div class="dropdown-menu dropdown-menu-right">
                                    ' .
                    $button .
                    '
                                </div>
                            </div>';
                return $action;
            })
            ->escapeColumns([])
            ->make(true);
    }

    // Custom Filter Member Qualified
    public function customFilterMemberQualified($request)
    {
        if (
            $request->type != null &&
            $request->type != "All" &&
            $request->filter != null
        ) {
            $members = Member::with("user", "member_type", "user_image")
                ->whereHas("user", function ($query) use ($request) {
                    $query
                        ->where(
                            "firstname",
                            "LIKE",
                            "%" . $request->filter . "%"
                        )
                        ->orWhere(
                            "lastname",
                            "LIKE",
                            "%" . $request->filter . "%"
                        );
                })
                ->orwhere(function ($query) use ($request) {
                    $query
                        ->orWhere(
                            "member_id",
                            "LIKE",
                            "%" . $request->filter . "%"
                        )
                        ->orWhere(
                            "card_number",
                            "LIKE",
                            "%" . $request->filter . "%"
                        )
                        ->orWhere(
                            "referral_code",
                            "LIKE",
                            "%" . $request->filter . "%"
                        );
                })
                ->whereHas("member_type", function ($query) use ($request) {
                    $query->where("name", $request->type);
                })
                ->where(
                    "members.current_points",
                    ">=",
                    $this->getAdminPointSettings()
                )
                ->where("members.registration_status", "!=", "Premium")
                ->limit(1000)
                ->get();
        } elseif ($request->type != null && $request->type != "All") {
            $members = Member::with("user", "member_type", "user_image")
                ->whereHas("member_type", function ($query) use ($request) {
                    $query->where("name", $request->type);
                })
                ->where(
                    "members.current_points",
                    ">=",
                    $this->getAdminPointSettings()
                )
                ->where("members.registration_status", "!=", "Premium")
                ->latest()
                ->limit(1000)
                ->get();
        } else {
            if ($request->filter != null) {
                $members = Member::with("user", "member_type", "user_image")
                    ->whereHas("user", function ($query) use ($request) {
                        $query
                            ->where(
                                "firstname",
                                "LIKE",
                                "%" . $request->filter . "%"
                            )
                            ->orWhere(
                                "lastname",
                                "LIKE",
                                "%" . $request->filter . "%"
                            );
                    })
                    ->orwhere(function ($query) use ($request) {
                        $query
                            ->orWhere(
                                "member_id",
                                "LIKE",
                                "%" . $request->filter . "%"
                            )
                            ->orWhere(
                                "card_number",
                                "LIKE",
                                "%" . $request->filter . "%"
                            )
                            ->orWhere(
                                "referral_code",
                                "LIKE",
                                "%" . $request->filter . "%"
                            );
                    })
                    ->where(
                        "members.current_points",
                        ">=",
                        $this->getAdminPointSettings()
                    )
                    ->where("members.registration_status", "!=", "Premium")
                    ->latest()
                    ->limit(1000)
                    ->get();
            } else {
                $members = Member::with("user", "member_type", "user_image")
                    ->where(
                        "members.current_points",
                        ">=",
                        $this->getAdminPointSettings()
                    )
                    ->where("members.registration_status", "!=", "Premium")
                    ->latest()
                    ->limit(1000)
                    ->get();
            }
        }
        return $members;
    }

    public function edit($id)
    {
        $member = Member::join("users", "members.user_id", "users.id")
            ->where("members.user_id", base64_decode($id))
            ->first();

        $member->card_number = $this->formatCardNumber($member->card_number);
        $member["path"] = isset($member->user->images[0])
            ? config("app.AWS_BUCKET_URL") . $member->user->images[0]->path
            : "";

        $params = [
            "user_id" => auth()->user()->id,
            "activity" => "Member Edit",
            "reference_id" => $member->user_id,
            "table" => "members and users",
            "remarks" => "Successfully viewed Edit member page.",
        ];

        $this->addLogs($params);

        return view("dashboard.members.edit", [
            "member" => $member,
            "member_types" => $this->getActiveMemberTypes(
                $member->member_type_id
            ),
            "area_codes" => $this->getActiveAreaCodes($member->area_code_id),
        ]);
    }

    public function view($id)
    {
        $member = Member::select([
            "users.firstname",
            "users.middlename",
            "users.lastname",
            "users.email",
            "users.username",
            "members.*",
            "member_types.name as member_type",
            "area_codes.area_name",
        ])
            ->join("users", "members.user_id", "users.id")
            ->leftjoin("area_codes", "members.area_code_id", "area_codes.id")
            ->leftjoin(
                "member_types",
                "members.member_type_id",
                "member_types.id"
            )
            ->where("members.user_id", base64_decode($id))
            ->first();

        $member["path"] = isset($member->user->images[0])
            ? config("app.AWS_BUCKET_URL") . $member->user->images[0]->path
            : asset("admin_dashboard/img/default.png");
        $member["name"] = $member->user->getFullName();
        $member["card_number"] = $this->formatCardNumber($member->card_number);
        $member["birth_date"] = $member->birthdate->format("M d, Y");
        $member["verification_dateformat"] = $member->verification_date
            ? $member->verification_date->format("M d, Y")
            : "";
        $member["expiration_dateformat"] = $member->expiration_date
            ? $member->expiration_date->format("M d, Y")
            : "";


        $referral_counter = 0;

        $referrals = Referral::where("user_upline_id", base64_decode($id))->get();
        foreach ($referrals as $key) {
           
            $check_membertype = Member::where("user_id", $key->user_id)
                                        ->where(function ($query) {
                                        $query->where('registration_status', '=', 'Regular')
                                              ->orWhere('registration_status', '=', 'unverified');
                                    })->count();

                if($check_membertype > 0){

                    $referral_counter++;

                }
            
        }
   
        

        $bayanihan_points = DB::table("bayanihan_point_settings")
            ->select("points")
            ->where("status", 1)
            ->first();

        $member["pending_points"] =  $bayanihan_points->points * $referral_counter;                    




        $params = [
            "user_id" => auth()->user()->id,
            "activity" => "Member View",
            "reference_id" => $member->user_id,
            "table" => "members and users",
            "remarks" => "Successfully viewed member.",
        ];

        $this->addLogs($params);

        return $member;
    }

    public function upgradeMember($id)
    {
        $user = User::where("id", "=", base64_decode($id))->first();
        $member = Member::where("user_id", "=", base64_decode($id))->first();

        return view("dashboard.members.upgrade", [
            "user_id" => $id,
            "full_name" => $user->firstname . " " . $user->lastname,
            "current_points" => $member->current_points,
        ]);
    }
    public function upgradeMembership($id)
    {
        $params = [];
        $params["registration_status"] = "Premium";

        $member = Member::where("user_id", base64_decode($id))->first();


        $params['current_points'] = $member->current_points - 200;

        if ($member->registration_status != "Premium") {
            if ($member->update($params)) {
                // commit all update

                $params = [
                    "user_id" => auth()->user()->id,
                    "activity" => "Member Upgrade",
                    "reference_id" => base64_decode($id),
                    "table" => "members",
                    "remarks" => "Successfully upgraded member.",
                ];

                $this->addLogs($params);


            $userUpline = Referral::where('user_id', base64_decode($id))->first();


            if($userUpline != null)
            {

                MemberPointTransactions::create([

                    'reference_id' => "REF# : ".strtoupper(Str::random(10)),
                    'user_id'=> $member->user_id,
                    'points'=> -200,
                    'upline_user_id' => $userUpline->user_upline_id,
                    'description' => 'Membership Upgrade',
                    'type'=> "membership_upgrade"

                ]);  

            }

            Mail::to($member->user->email)->send(new VerifyMember($member->user));

            }
        }

        $this->updateReferrerPonts(base64_decode($id));


        if (auth()->user()->isSuperAdmin() || auth()->user()->isAdmin() || auth()->user()->isAdminCashier()) {
            return redirect()->action([ViewController::class, "index"]);     
        } 

        return Redirect::route('bayanihan');      
       
    }

    public function updateReferrerPonts($userId) {
        $point = BayanihanPointSetting::where('status' , 1)->first();
        $referrer = Referral::where('user_id', $userId)->first();
        DB::table('members')
                ->where('user_id', $referrer->user_upline_id)
                ->increment('current_points', (int)$point->points);
        DB::table('members')
                ->where('user_id', $referrer->user_upline_id)
                ->increment('total_points', (int)$point->points);   
    }

    public function getAdminPointSettings()
    {
        $point = AdminPointSetting::whereStatus(1)->first();
        return isset($point->qualified_points) ? $point->qualified_points : 199;
    }

    public function getActiveAreaCodes($id = null)
    {
        if ($id) {
            return AreaCode::whereStatus(1)
                ->orWhere("id", $id)
                ->get(["id", "area_name"]);
        }
        return AreaCode::whereStatus(1)->get(["id", "area_name"]);
    }

    public function getActiveMemberTypes($id = null)
    {
        if ($id) {
            return MemberType::whereStatus(1)
                ->orWhere("id", $id)
                ->get(["id", "name"]);
        }
        return MemberType::whereStatus(1)->get(["id", "name"]);
    }

    public function formatCardNumber($card_number)
    {
        return implode("-", str_split($card_number, 4));
    }
}
