<?php

namespace App\Http\Controllers\Dashboard\Member;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

//Add Models
use App\Models\Member;
use App\Models\User;
use App\Models\Referral;
use App\Models\BayanihanPointSetting;
use App\Models\MemberPointTransactions;
//Mails
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Str;
use App\Mail\VerifyMember;

use Redirect;
use File;
use Hash;
use DB;

class UpdateController extends Controller
{
	public function index(Request $request, $id)
	{	
		DB::beginTransaction();

		$userParams = $request->only(['firstname','middlename','lastname','username','email','password','usertype']);
		$user = User::find(base64_decode($id));

		if ($user->update($userParams)) {
			
			$params = $request->except(['_token','firstname','middlename','lastname','username','email','password','usertype']);
			$member = Member::where('user_id', base64_decode($id))->first();

			if ($member->update($params)) {
				// commit all update
				DB::commit();
				
				//ASSIGN ROLE
				$this->updateRole($user);

				//SAVE IMAGE TO S3
				$this->storeUserImage($request, base64_decode($id));

				$params = [
					'user_id' => auth()->user()->id, 
					'activity' => 'Member Update',
					'reference_id' => base64_decode($id),
					'table' => 'members and users',
					'remarks' => 'Successfully updated member.',
				];

				$this->addLogs($params);

				return Redirect::route('members')->with(['success' => 'Successfully updated member']);
			}
			
			// Rollback and then redirect & back to form with errors
			DB::rollback();

			$params = [
				'user_id' => auth()->user()->id, 
				'activity' => 'Member Update',
				'reference_id' => base64_decode($id),
				'table' => 'members and users',
				'remarks' => 'Failed to update member.',
			];

			$this->addLogs($params);

			return Redirect::route('members.edit', $id)
				->withErrors($member->getErrors())
				->withInput();
		}

		$params = [
			'user_id' => auth()->user()->id, 
			'activity' => 'Member Update',
			'reference_id' => base64_decode($id),
			'table' => 'members and users',
			'remarks' => 'Failed to update member.',
		];

		$this->addLogs($params);

		return Redirect::route('members.edit', $id)
			->withErrors($user->getErrors())
			->withInput();
	}

	// verify member status
	public function verify(Request $request)
	{   
				
		$member = Member::where('user_id', base64_decode($request->user_id))->first();

		$params = [
			'or_number'             => $request->or_number,
			'area_code_id'          => $request->area_code_id,
			'registration_status'   => 'Premium',
			'current_points'        => $member->current_points,
		];


		if ($member->update($params)) {
			$params = [
				'user_id' => auth()->user()->id, 
				'activity' => 'Member Verify',
				'reference_id' => base64_decode($request->user_id),
				'table' => 'members and users',
				'remarks' => 'Successfully verified member.',
			];

			$this->addLogs($params);


			$userUpline = Referral::where('user_id', base64_decode($request->user_id))->first();


			if($userUpline != null)
			{

				MemberPointTransactions::create([

					'reference_id' => "REF# : ".strtoupper(Str::random(10)),
					'user_id'=> $member->user_id,
					'points'=> -200,
					'upline_user_id' => $userUpline->user_upline_id,
					'description' => 'Membership Upgrade',
					'type'=> "membership_upgrade"

				]);  

			}
			// send email
			Mail::to($member->user->email)->send(new VerifyMember($member->user));
			$this->updateReferrerPonts( base64_decode($request->user_id));
			return response()->json(['message' => 'Successfully Verified Member']);
		}

		$params = [
			'user_id' => auth()->user()->id, 
			'activity' => 'Member Verify',
			'reference_id' => base64_decode($request->user_id),
			'table' => 'members and users',
			'remarks' => 'Failed to verify member.',
		];
		
		$this->addLogs($params);

		return response()->json(['error' => $member->getErrors()]);
	}

	public function updateReferrerPonts($userId) {
		$point = BayanihanPointSetting::where('status' , 1)->first();
		$referrer = Referral::where('user_id', $userId)->first();
		DB::table('members')
				->where('user_id', $referrer->user_upline_id)
				->increment('current_points', (int)$point->points);
		DB::table('members')
				->where('user_id', $referrer->user_upline_id)
				->increment('total_points', (int)$point->points);		
	}
}
