<?php

namespace App\Http\Controllers\Dashboard\Member;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

//Add Models
use App\Models\Member;
use App\Models\User;

//Mails
use Illuminate\Support\Facades\Mail;
use App\Mail\SendReferralLink;

use Redirect;
use Hash;
use DB;

class CreateController extends Controller
{
    public function index(Request $request)
    {	
    	$request->merge([
    		'member_id'	  	   => $this->generateMemberId(),
            'card_number'      => $this->generateCardNumber(),
    		'referral_code'    => $this->generateReferralCode(),
    		'password' 		   => Hash::make('primaryplus'),
    		'usertype' 		   => 'member',
    	]);

    	DB::beginTransaction();

    	$userParams = $request->only(['firstname','middlename','lastname','username','email','password','usertype']);
    	$user = new User($userParams);

    	if ($user->save()) {

    		$params = $request->except(['firstname','middlename','lastname','username','email','password','usertype']);
    		$params['user_id'] = $user->id;
            $member = new Member($params);

			if (!$member->save()) {
    			// Rollback and then redirect & back to form with errors
   				DB::rollback();

                $params = [
                    'user_id' => auth()->user()->id, 
                    'activity' => 'Member Registration',
                    'reference_id' => null,
                    'table' => 'members and users',
                    'remarks' => 'Error registering member.',
                ];

                $this->addLogs($params);
                
				return Redirect::route('members.add')
			        ->withErrors($member->getErrors())
			        ->withInput();
			}

            //SAVE IMAGE TO S3
            $this->storeUserImage($request, $user->id);
            
            //ASSIGN ROLE
            $this->assignRole($user);

    		DB::commit();

            $params = [
                'user_id' => auth()->user()->id, 
                'activity' => 'Member Registration',
                'reference_id' => $user->id,
                'table' => 'members and users',
                'remarks' => 'Successfully registered member.',
            ];

            $this->addLogs($params);

			return Redirect::route('members')->with(['success' => 'Successfully added new member']);
    	}

        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Member Registration',
            'reference_id' => null,
            'table' => 'members and users',
            'remarks' => 'Error registering member.',
        ];

        $this->addLogs($params);
        
		return Redirect::route('members.add')
	        ->withErrors($user->getErrors())
	        ->withInput();
    }

    public function sendReferral(Request $request)
    {
        $params = $request->all();
        Mail::to($request->email)->send(new SendReferralLink($params));

        return response()->json(['message' => 'Successfully send email']);
    }

    // Generate Member ID according based on last member_id
    public function generateMemberId()
    {
    	$generated_id = Member::select(['member_id'])
    		->orderBy('created_at','desc')
    		->first();

    	return $generated_id['member_id'] + 1;
    }

    // Generate Card Number
    public function generateCardNumber()
    {   
        $code = $this->generateNumericCode();
        $member = Member::where('card_number', $code)->first();

        if (isset($member)) {
            $this->generateNumericCode();
        }
        
        return $code;
    }

    // Generate 16 digits Numberic Code
    public function generateNumericCode()
    {
        $code = '';
        for($i = 0; $i < 16; $i++) { 
            $code .= mt_rand(0, 9); 
        }

        return $code;
    }

    // Generate Referral Code
    public function generateReferralCode()
    {
        $code = $this->generateAlphaNumeric(7);
        $member = Member::where('referral_code', $code)->first();

        if (isset($member)) {
            $code = $this->generateAlphaNumeric(7);
        }    

        return $code;
    }

    // Generate Alpha Numberic
    public function generateAlphaNumeric($limit)
    {
        $code = substr(base_convert(sha1(uniqid(mt_rand())), 16, 36), 0, $limit);

        return strtoupper($code);
    }
}
