<?php

namespace App\Http\Controllers\Dashboard\Main;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

//Add Models
use App\Models\PromotionLog;
use App\Models\DoctorAppointment;
use App\Models\TransactionOrder;
use App\Models\MerchantCashier;
use App\Models\DoctorReview;
use App\Models\MerchantReview;
use App\Models\DoctorSchedule;
use App\Models\Merchant;
use App\Models\Product;
use App\Models\Member;
use App\Models\Doctor;
use App\Models\Point;
use App\Models\User;
use Redirect;

use DB;

class ViewController extends Controller
{
    public function index()
    {	

        if(auth()->user()->isMember()) {
            return Redirect::route('bayanihan');
        }
        
        if(auth()->user()->isMerchantCashier()) {
            return Redirect::route('profile');
        }
        $merchant = auth()->user()->isMerchantAdmin() ? Merchant::find(auth()->user()->account->merchant_id) : null ;
        $points = Point::select([
                    DB::raw("FORMAT(SUM(system), 'N', 'en-us') as total_system"),
                    DB::raw("FORMAT(SUM(advocacy), 'N', 'en-us') as total_advocacy"),
                    DB::raw("FORMAT(SUM(points), 'N', 'en-us') as total_points"),
                ])
                ->first();

        $merchant = auth()->user()->isMerchantAdmin() ? Merchant::find(auth()->user()->account->merchant_id) : null ;

        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Dashboard',
            'reference_id' => null,
            'table' => 'members, merchants and promotion_logs',
            'remarks' => 'Success viewing dashboard.',
        ];

        $this->addLogs($params);

    	return view('dashboard.main.dashboard',[
            'member_count'              => Member::count(),
            'merchant_count'            => Merchant::count(),
            'total_points_payment'      => PromotionLog::sum('points_amount'),
            'total_system'              => ($points->total_system != null) ? $points->total_system : 0,
            'total_advocacy'            => ($points->total_advocacy != null) ? $points->total_advocacy : 0,
            'total_points'              => ($points->total_points != null) ? $points->total_points : 0,
            'merchant_cashier_count'    => $this->getMerchantCashierCount(),
            'merchant_doctor_count'     => $this->getMerchantDoctorCount(),
            'merchant_patient_count'    => $this->getMerchantPatientCount(),
            'merchant_review_count'     => $this->getMerchantReviewCount(),
            'pending_orders_count'      => $this->getPendingOrdersCount(),
            'customer_count'            => $this->getMerchantCustomerCount(),
            'product_count'             => $this->getMerchantProductCount(),
            'maintaining_balance'       => ($merchant != null) ? $merchant->mb_amount * ($merchant->mb_percent / 100) : 0,
            'remaining_balance'         => ($merchant != null) ? $merchant->getWalletBalance() : 0,
            'doctor_appointment_count'  => $this->getDoctorAppointmentCount(),
            'doctor_patient_count'      => $this->getDoctorPatientCount(),
            'doctor_reviews_count'      => $this->getDoctorReviewCount(),
        ]);
    }

    public function profile()
    {	
        $user = User::find(auth()->user()->id);
        $user['image'] = isset($user->images[0]) ? config('app.AWS_BUCKET_URL').$user->images[0]->path : asset('admin_dashboard/img/default.png');     	

        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Profile',
            'reference_id' => auth()->user()->id,
            'table' => 'logs',
            'remarks' => 'Success viewing profile.',
        ];

        $this->addLogs($params);

        if (auth()->user()->isDoctor()) {
            $user['schedules'] = $this->getDoctorSchedules(auth()->user()->account->id);
        }

    	return view('dashboard.main.profile',[
    		'user' => $user
    	]);
    }

    // get merchant cashier count
    public function getMerchantCashierCount()
    {
        $count = 0;
        if(isset(auth()->user()->account->merchant_id)) {
            $count = MerchantCashier::where('merchant_id', auth()->user()->account->merchant_id)->count();
        } else {
            $count = MerchantCashier::count();
        }
        return $count;
    }

    // get merchant doctor count
    public function getMerchantDoctorCount()
    {
        $count = 0;
        if(isset(auth()->user()->account->merchant_id)) {
            $count = Doctor::where('merchant_id', auth()->user()->account->merchant_id)->count();
        }
        return $count;
    }

    // get merchant patient count
    public function getMerchantPatientCount()
    {
        $count = 0;       
        if(isset(auth()->user()->account->merchant_id)) {
            $count = DoctorAppointment::join('doctors', 'doctors.id', 'doctor_appointments.doctor_id')
                            ->where('doctors.merchant_id', auth()->user()->account->merchant_id)
                            ->groupBy('doctor_appointments.user_id')
                            ->count();
        }
        return $count;
    }

    // get merchant review count
    public function getMerchantReviewCount()
    {   
        $count = 0;
        if (auth()->user()->isMerchantAdmin()) {
            if (isset(auth()->user()->account->merchant_id)) {
                if (auth()->user()->account->merchant->is_mobile == 1 && (isset(auth()->user()->account->merchant->merchantAgreement->application_type) && auth()->user()->account->merchant->merchantAgreement->application_type == 'kol-a')) {
                    $count = DoctorReview::where('doctors.merchant_id', auth()->user()->account->merchant_id)
                                ->join('doctor_appointments', 'doctor_appointments.id', 'doctor_reviews.appointment_id')
                                ->leftJoin('doctors', 'doctors.id', 'doctor_appointments.doctor_id')
                                ->count();
                } else {
                    $count = MerchantReview::where('merchant_id', auth()->user()->account->merchant_id)->count();
                }
                return $count;
            }
        }
        return $count;
    }

    // get merchant pending orders count
    public function getPendingOrdersCount()
    {
        $count = 0;       
        if (isset(auth()->user()->account->merchant->merchantAgreement->establishment_id)) {
            $count = TransactionOrder::where('establishment_id', auth()->user()->account->merchant->merchantAgreement->establishment_id)
                            ->where('status','pending')
                            ->count();
        }
        return $count;
    }

    // get merchant customer orders count
    public function getMerchantCustomerCount()
    {
        $count = 0;
        if (isset(auth()->user()->account->merchant->merchantAgreement->establishment_id)) {
            $count = TransactionOrder::select('user_id')->where('establishment_id', auth()->user()->account->merchant->merchantAgreement->establishment_id)
                            ->groupBy(['user_id'])
                            ->get()
                            ->count();
        }
        return $count;
    }

    // get merchant product count
    public function getMerchantProductCount()
    {   
        $count = 0;
        if (isset(auth()->user()->account->merchant->merchantAgreement->establishment_id)) {
            $count = Product::join('establishments', 'establishments.id', 'products.establishment_id')
                        ->where('establishments.id', auth()->user()->account->merchant->merchantAgreement->establishment_id)
                        ->count();
        }
        return $count;
    }

    // get doctor appoinment count
    public function getDoctorAppointmentCount()
    {
        $count = 0;
        if (auth()->user()->isDoctor()) {
            $count = DoctorAppointment::where('doctor_id', auth()->user()->account->id)
                            ->where('status','pending')
                            ->count();
        } 
        return $count;
    }

    // get doctor patient count
    public function getDoctorPatientCount()
    {
        $count = 0;
        if (auth()->user()->isDoctor()) {
            $count = DoctorAppointment::join('doctors', 'doctors.id', 'doctor_appointments.doctor_id')
                            ->where('doctors.id', auth()->user()->account->id)
                            ->groupBy('doctor_appointments.user_id')
                            ->count();                
        } 
        return $count;
    }

     // get doctor review count
    public function getDoctorReviewCount()
    {   
        $count = 0;
        if (auth()->user()->isDoctor()) {
            $count = DoctorReview::join('doctor_appointments', 'doctor_appointments.id', 'doctor_reviews.appointment_id')
                            ->where('doctor_appointments.doctor_id', auth()->user()->account->id)
                            ->count();
        } 
        return $count;    
    }

    // get schedules
    public function getDoctorSchedules($id)
    {
        $schedule = DoctorSchedule::where('doctor_id', $id)->first();

        $schedules = (Object)[
            'monday'    => $this->formatScheduleTime(optional($schedule)->monday),
            'tuesday'   => $this->formatScheduleTime(optional($schedule)->tuesday),
            'wednesday' => $this->formatScheduleTime(optional($schedule)->wednesday),
            'thursday'  => $this->formatScheduleTime(optional($schedule)->thursday),
            'friday'    => $this->formatScheduleTime(optional($schedule)->friday),
            'saturday'  => $this->formatScheduleTime(optional($schedule)->saturday),
            'sunday'    => $this->formatScheduleTime(optional($schedule)->sunday),
        ];

        return $schedules;
    }

    // format schedule time
    public function formatScheduleTime($time)
    {
        $amFrom = substr($time, 1, 8);
        $amTo = substr($time, 12, 8);
        $pmFrom = substr($time, 25, 8);
        $pmTo = substr($time, 36, 8);

        $amFrom = ($amFrom != null && $amFrom != '00:00 AM') ? date('H:i', strtotime($amFrom)) : '';
        $amTo = ($amTo != null && ($amTo != '00:00 AM' && $amTo != '00:00 PM')) ? date('H:i', strtotime($amTo)) : '';
        $pmFrom = ($pmFrom != null && $pmFrom != '00:00 PM') ? date('H:i', strtotime($pmFrom)) : '';
        $pmTo = ($pmTo != null && $pmTo != '00:00 PM') ? date('H:i', strtotime($pmTo)) : '';
        
        return [$amFrom, $amTo, $pmFrom, $pmTo];
    }
}
